/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.GenerateSQLVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.store.SQLGenerator;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class GenerateSQL
implements SQLGenerator {
    public static boolean forceOldGenerator = false;

    public static String toSQL(SDBRequest request, SqlNode sqlNode) {
        return new GenerateSQL().generateSQL(request, sqlNode);
    }

    public static String toPartSQL(SDBRequest request, SqlNode sqlNode) {
        return new GenerateSQL().generatePartSQL(sqlNode);
    }

    @Override
    public String generateSQL(SDBRequest request, SqlNode sqlNode) {
        sqlNode = GenerateSQL.ensureProject(request, sqlNode);
        return this.generatePartSQL(sqlNode);
    }

    public String generatePartSQL(SqlNode sqlNode) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        SqlNodeVisitor v = this.makeVisitor(buff);
        sqlNode.visit(v);
        return buff.asString();
    }

    protected SqlNodeVisitor makeVisitor(IndentedLineBuffer buff) {
        return new GenerateSQLVisitor((IndentedWriter)buff);
    }

    public static SqlNode ensureProject(SDBRequest request, SqlNode sqlNode) {
        if (!sqlNode.isSelectBlock()) {
            sqlNode = SqlSelectBlock.project(request, sqlNode);
        }
        return sqlNode;
    }
}

