/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QuadBlock;
import com.hp.hpl.jena.sdb.compiler.QuadBlockCompiler;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformSDB
extends TransformCopy {
    private static Logger log = LoggerFactory.getLogger(TransformSDB.class);
    private SDBRequest request;
    private QuadBlockCompiler quadBlockCompiler;

    public TransformSDB(SDBRequest request, QuadBlockCompiler quadBlockCompiler) {
        this.request = request;
        this.quadBlockCompiler = quadBlockCompiler;
    }

    public Op transform(OpBGP opBGP) {
        return opBGP;
    }

    public Op transform(OpQuadPattern quadPattern) {
        QuadBlock qBlk = new QuadBlock(quadPattern);
        SqlNode node = this.quadBlockCompiler.compile(qBlk);
        return new OpSQL(node, (Op)quadPattern, this.request);
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        return super.transform(opJoin, left, right);
    }

    public Op transform(OpLeftJoin opJoin, Op left, Op right) {
        Set<Var> rightOptVars;
        if (!this.request.LeftJoinTranslation) {
            return super.transform(opJoin, left, right);
        }
        if (!SDB_QC.isOpSQL(left) || !SDB_QC.isOpSQL(right)) {
            return super.transform(opJoin, left, right);
        }
        if (opJoin.getExprs() != null) {
            return super.transform(opJoin, left, right);
        }
        SqlNode sqlLeft = ((OpSQL)left).getSqlNode();
        SqlNode sqlRight = ((OpSQL)right).getSqlNode();
        Set<ScopeEntry> scopes = sqlLeft.getIdScope().findScopes();
        Set scopes2 = Iter.toSet((Iterator)Iter.filter(scopes, ScopeEntry.OptionalFilter));
        Set leftOptVars = Iter.toSet((Iterator)Iter.map((Iterable)scopes2, ScopeEntry.ToVar));
        Set coalesceVars = SetUtils.intersection((Set)leftOptVars, rightOptVars = sqlRight.getIdScope().getVars());
        if (coalesceVars.size() > 0) {
            String alias = this.request.genId("M");
            SqlNode sqlNode = SqlBuilder.leftJoinCoalesce(this.request, alias, sqlLeft, sqlRight, coalesceVars);
            return new OpSQL(sqlNode, (Op)opJoin, this.request);
        }
        return new OpSQL(SqlBuilder.leftJoin(this.request, sqlLeft, sqlRight, null), (Op)opJoin, this.request);
    }

    public Op transform(OpFilter opFilter, Op op) {
        return super.transform(opFilter, op);
    }

    public Op transform(OpTable opTable) {
        if (!opTable.isJoinIdentity()) {
            log.error("OpTable : Not join identity");
        }
        return super.transform(opTable);
    }

    public Op transform(OpDistinct opDistinct, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opDistinct, subOp);
        }
        if (!this.request.DistinctTranslation) {
            return super.transform(opDistinct, subOp);
        }
        OpSQL opSubSQL = (OpSQL)subOp;
        SqlNode sqlSubOp = opSubSQL.getSqlNode();
        SqlNode n = SqlSelectBlock.distinct(this.request, sqlSubOp);
        OpSQL opSQL = new OpSQL(n, (Op)opDistinct, this.request);
        opSQL.setBridge(opSubSQL.getBridge());
        return opSQL;
    }

    public Op transform(OpProject opProject, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opProject, subOp);
        }
        List vars = opProject.getVars();
        return TransformSDB.doBridge(this.request, (OpSQL)subOp, vars, (Op)opProject);
    }

    public Op transform(OpService opService, Op subOp) {
        return opService;
    }

    private static OpSQL doBridge(SDBRequest request, OpSQL opSQL, List<Var> projectVars, Op original) {
        SqlNode sqlNode = opSQL.getSqlNode();
        SQLBridgeFactory f = request.getStore().getSQLBridgeFactory();
        SQLBridge bridge = f.create(request, sqlNode, projectVars);
        bridge.build();
        sqlNode = bridge.getSqlNode();
        opSQL = new OpSQL(sqlNode, original, request);
        opSQL.setBridge(bridge);
        opSQL.resetSqlNode(sqlNode);
        return opSQL;
    }

    public Op transform(OpDatasetNames opDatasetNames) {
        Node g = opDatasetNames.getGraphNode();
        if (!Var.isVar((Node)g)) {
            throw new SDBInternalError("OpDatasetNames - not a variable: " + g);
        }
        Var v = Var.alloc((Node)g);
        TableDescQuads quads = this.request.getStore().getQuadTableDesc();
        SqlTable sqlTableQ = new SqlTable(quads.getTableName());
        sqlTableQ.setIdColumnForVar(v, new SqlColumn(sqlTableQ, quads.getGraphColName()));
        SqlNode sqlNodeQ = SqlSelectBlock.distinct(this.request, sqlTableQ);
        return new OpSQL(sqlNodeQ, (Op)opDatasetNames, this.request);
    }
}

