/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QueryCompiler;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.openjena.atlas.io.IndentedWriter;

public class QueryIterOpSQL
extends QueryIterRepeatApply {
    private OpSQL opSQL;

    public QueryIterOpSQL(OpSQL op, QueryIterator input, ExecutionContext context) {
        super(input, context);
        this.opSQL = op;
    }

    protected QueryIterator nextStage(Binding binding) {
        OpSQL execSQL = this.opSQL;
        if (binding != null && !QueryIterOpSQL.isRoot(binding)) {
            Op op2;
            QueryCompiler qc = this.opSQL.getRequest().getStore().getQueryCompilerFactory().createQueryCompiler(this.opSQL.getRequest());
            Op op = qc.compile(op2 = Substitute.substitute((Op)this.opSQL.getOriginal(), (Binding)binding));
            if (op instanceof OpSQL) {
                execSQL = (OpSQL)op;
            } else {
                throw new SDBInternalError("Failed to recompile the OpSQL to an OpSQL");
            }
        }
        return execSQL.exec(binding, this.getExecContext());
    }

    private static boolean isRoot(Binding binding) {
        return !binding.vars().hasNext();
    }

    public void output(IndentedWriter out) {
        this.opSQL.output(out);
    }
}

