/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.sql.MySQLEngineType;
import com.hp.hpl.jena.sdb.sql.SDBConnectionDesc;
import com.hp.hpl.jena.sdb.store.Feature;
import com.hp.hpl.jena.sdb.store.FeatureSet;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDescAssembler
extends AssemblerBase
implements Assembler {
    private static Logger log;

    public StoreDesc open(Assembler a, Resource root, Mode mode) {
        SDBConnectionDesc sdbConnDesc = null;
        Resource c = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pConnection);
        if (c != null) {
            sdbConnDesc = (SDBConnectionDesc)a.open(c);
        }
        String layoutName = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pLayout);
        String dbType = this.chooseDBType(root, sdbConnDesc);
        List x = GraphUtils.multiValueResource((Resource)root, (Property)AssemblerVocab.featureProperty);
        FeatureSet fSet = new FeatureSet();
        for (Resource r : x) {
            String n = GraphUtils.getStringValue((Resource)r, (Property)AssemblerVocab.featureNameProperty);
            String v = GraphUtils.getStringValue((Resource)r, (Property)AssemblerVocab.featureValueProperty);
            Feature f = new Feature(new Feature.Name(n), v);
            fSet.addFeature(f);
        }
        StoreDesc storeDesc = new StoreDesc(layoutName, dbType, fSet);
        storeDesc.connDesc = sdbConnDesc;
        String engineName = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pMySQLEngine);
        storeDesc.engineType = null;
        if (engineName != null) {
            try {
                storeDesc.engineType = MySQLEngineType.convert(engineName);
            }
            catch (SDBException ex) {
                // empty catch block
            }
        }
        return storeDesc;
    }

    private String chooseDBType(Resource root, SDBConnectionDesc sdbConnDesc) {
        String dbTypeConn = sdbConnDesc != null ? sdbConnDesc.getType() : null;
        String dbType = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pSDBtype);
        if (dbTypeConn != null && dbType != null) {
            if (!dbTypeConn.equals(dbType)) {
                String $ = String.format("Connection-specified DB type and store description dbtype are different : %s %s", dbTypeConn, dbType);
                log.warn($);
            }
        } else if (dbType != null) {
            if (sdbConnDesc != null) {
                sdbConnDesc.setType(dbType);
            }
        } else if (dbTypeConn != null) {
            dbType = dbTypeConn;
        } else {
            log.warn("Failed to determine the database type (not in store description, no connection description)");
            throw new SDBException("No database type found");
        }
        return dbType;
    }

    static {
        SDB.init();
        log = LoggerFactory.getLogger(StoreDescAssembler.class);
    }
}

