/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openimaj.audio.AudioPlayer;
import org.openimaj.audio.AudioStream;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.time.TimeKeeper;
import org.openimaj.time.Timecode;
import org.openimaj.video.ArrayBackedVideo;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.VideoDisplayStateListener;
import org.openimaj.video.VideoPositionListener;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;

public class VideoDisplay<T extends Image<?, T>>
implements Runnable {
    private Mode mode = Mode.PLAY;
    private final DisplayUtilities.ImageComponent screen;
    private Video<T> video;
    private final List<VideoDisplayListener<T>> videoDisplayListeners;
    private final List<VideoDisplayStateListener> stateListeners;
    private final List<VideoPositionListener> positionListeners;
    private boolean displayMode = true;
    private EndAction endAction = EndAction.STOP_AT_END;
    private AudioPlayer audioPlayer = null;
    private TimeKeeper<? extends Timecode> timeKeeper = null;
    private double calculatedFPS = 0.0;
    private final boolean fireUpdates = true;
    private long currentFrameTimestamp = 0L;
    private T currentFrame = null;
    private int droppedFrameCount = 0;
    private boolean calculateFPS = true;

    public VideoDisplay(Video<T> v, DisplayUtilities.ImageComponent screen) {
        this(v, null, screen);
    }

    public VideoDisplay(Video<T> v, AudioStream a, DisplayUtilities.ImageComponent screen) {
        this.video = v;
        this.timeKeeper = a != null ? (this.audioPlayer = new AudioPlayer(a)) : new BasicVideoTimeKeeper(this.video.countFrames() == -1L);
        this.screen = screen;
        this.videoDisplayListeners = new ArrayList<VideoDisplayListener<T>>();
        this.stateListeners = new ArrayList<VideoDisplayStateListener>();
        this.positionListeners = new ArrayList<VideoPositionListener>();
    }

    @Override
    public void run() {
        BufferedImage bimg = null;
        this.currentFrame = this.video.getCurrentFrame();
        long roughSleepTime = 10L;
        long tolerance = 10L;
        long lastTimestamp = 0L;
        long currentTimestamp = 0L;
        this.fireVideoStartEvent();
        new Thread((Runnable)this.timeKeeper).start();
        while (this.mode != Mode.CLOSED) {
            if (this.mode == Mode.PLAY || this.mode == Mode.PAUSE) {
                if (this.calculateFPS) {
                    currentTimestamp = System.currentTimeMillis();
                    this.calculatedFPS = 1000.0 / (double)(currentTimestamp - lastTimestamp);
                    lastTimestamp = currentTimestamp;
                }
                T nextFrame = this.currentFrame;
                long nextFrameTimestamp = this.currentFrameTimestamp;
                if (this.mode == Mode.PLAY) {
                    if (this.video.countFrames() != -1L && this.currentFrame != null) {
                        long t = this.timeKeeper.getTime().getTimecodeInMilliseconds();
                        int droppedThisRound = -1;
                        while (nextFrameTimestamp <= t && nextFrame != null) {
                            nextFrame = this.video.getNextFrame();
                            nextFrameTimestamp = this.video.getTimeStamp();
                            ++droppedThisRound;
                        }
                        this.droppedFrameCount += droppedThisRound;
                    } else {
                        nextFrame = this.video.getNextFrame();
                        nextFrameTimestamp = this.video.getTimeStamp();
                        if (this.currentFrame == null && this.timeKeeper instanceof BasicVideoTimeKeeper) {
                            ((BasicVideoTimeKeeper)this.timeKeeper).setTimeOffset(-nextFrameTimestamp);
                        }
                    }
                    if (nextFrame == null) {
                        this.processEndAction(this.endAction);
                        continue;
                    }
                }
                this.getClass();
                this.fireBeforeUpdate(this.currentFrame);
                if (this.displayMode && this.currentFrame != null) {
                    bimg = ImageUtilities.createBufferedImageForDisplay(this.currentFrame, bimg);
                    this.screen.setImage(bimg);
                }
                this.getClass();
                this.fireVideoUpdate();
                roughSleepTime = (long)(1000.0 / this.video.getFPS()) - 10L;
                if (this.mode == Mode.PLAY) {
                    while (this.timeKeeper.getTime().getTimecodeInMilliseconds() < nextFrameTimestamp && this.mode == Mode.PLAY) {
                        try {
                            Thread.sleep(Math.max(0L, roughSleepTime));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.currentFrame = nextFrame;
                    this.currentFrameTimestamp = nextFrameTimestamp;
                    continue;
                }
                try {
                    Thread.sleep(Math.max(0L, roughSleepTime));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void processEndAction(EndAction e) {
        this.fireVideoEndEvent();
        switch (e) {
            case LOOP: {
                this.video.reset();
                if (this.audioPlayer != null) {
                    this.audioPlayer.reset();
                }
                this.timeKeeper.reset();
                this.currentFrameTimestamp = 0L;
                this.fireVideoStartEvent();
                break;
            }
            case PAUSE_AT_END: {
                this.setMode(Mode.PAUSE);
                break;
            }
            case STOP_AT_END: {
                this.setMode(Mode.STOP);
                break;
            }
            case CLOSE_AT_END: {
                this.setMode(Mode.CLOSED);
            }
        }
    }

    public synchronized void close() {
        this.setMode(Mode.CLOSED);
    }

    public synchronized void setMode(Mode m) {
        if (this.mode == Mode.CLOSED) {
            return;
        }
        if (m == this.mode) {
            return;
        }
        switch (m) {
            case PLAY: {
                if (this.mode == Mode.STOP) {
                    this.fireVideoStartEvent();
                }
                new Thread((Runnable)this.timeKeeper).start();
                this.currentFrame = this.video.getCurrentFrame();
                this.currentFrameTimestamp = this.video.getTimeStamp();
                break;
            }
            case STOP: {
                this.timeKeeper.stop();
                this.timeKeeper.reset();
                if (this.audioPlayer != null) {
                    this.audioPlayer.stop();
                    this.audioPlayer.reset();
                }
                this.video.reset();
                this.currentFrameTimestamp = 0L;
                break;
            }
            case PAUSE: {
                System.out.println("Does timekeeper support pause? " + this.timeKeeper.supportsPause());
                if (!this.timeKeeper.supportsPause()) break;
                this.timeKeeper.pause();
                break;
            }
            case CLOSED: {
                this.timeKeeper.stop();
                this.video.close();
                break;
            }
        }
        this.mode = m;
        this.fireStateChanged();
    }

    protected Mode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeforeUpdate(T currentFrame) {
        List<VideoDisplayListener<T>> list = this.videoDisplayListeners;
        synchronized (list) {
            for (VideoDisplayListener<T> vdl : this.videoDisplayListeners) {
                vdl.beforeUpdate(currentFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVideoUpdate() {
        List<VideoDisplayListener<T>> list = this.videoDisplayListeners;
        synchronized (list) {
            for (VideoDisplayListener<T> vdl : this.videoDisplayListeners) {
                vdl.afterUpdate(this);
            }
        }
    }

    public DisplayUtilities.ImageComponent getScreen() {
        return this.screen;
    }

    public Video<T> getVideo() {
        return this.video;
    }

    public void changeVideo(Video<T> newVideo) {
        this.video = newVideo;
        this.timeKeeper = new BasicVideoTimeKeeper(newVideo.countFrames() == -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoListener(VideoDisplayListener<T> dsl) {
        List<VideoDisplayListener<T>> list = this.videoDisplayListeners;
        synchronized (list) {
            this.videoDisplayListeners.add(dsl);
        }
    }

    public void addVideoDisplayStateListener(VideoDisplayStateListener vdsl) {
        this.stateListeners.add(vdsl);
    }

    public void removeVideoDisplayStateListener(VideoDisplayStateListener vdsl) {
        this.stateListeners.remove(vdsl);
    }

    protected void fireStateChanged() {
        for (VideoDisplayStateListener s : this.stateListeners) {
            s.videoStateChanged(this.mode, this);
            switch (this.mode) {
                case PAUSE: {
                    s.videoPaused(this);
                    break;
                }
                case PLAY: {
                    s.videoPlaying(this);
                    break;
                }
                case STOP: {
                    s.videoStopped(this);
                    break;
                }
                case CLOSED: {
                    break;
                }
                case SEEK: {
                    break;
                }
            }
        }
    }

    public void addVideoPositionListener(VideoPositionListener vpl) {
        this.positionListeners.add(vpl);
    }

    public void removeVideoPositionListener(VideoPositionListener vpl) {
        this.positionListeners.remove(vpl);
    }

    protected void fireVideoStartEvent() {
        for (VideoPositionListener vpl : this.positionListeners) {
            vpl.videoAtStart(this);
        }
    }

    protected void fireVideoEndEvent() {
        for (VideoPositionListener vpl : this.positionListeners) {
            vpl.videoAtEnd(this);
        }
    }

    public void togglePause() {
        if (this.mode == Mode.CLOSED) {
            return;
        }
        if (this.mode == Mode.PLAY) {
            this.setMode(Mode.PAUSE);
        } else if (this.mode == Mode.PAUSE) {
            this.setMode(Mode.PLAY);
        }
    }

    public boolean isPaused() {
        return this.mode == Mode.PAUSE;
    }

    public boolean isStopped() {
        return this.mode == Mode.STOP;
    }

    public void setEndAction(EndAction action) {
        this.endAction = action;
    }

    public static VideoDisplay<FImage> createVideoDisplay(FImage[] images) {
        return VideoDisplay.createVideoDisplay(new ArrayBackedVideo((Image[])images, 30.0));
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video) {
        JFrame screen = DisplayUtilities.makeFrame((String)"Video");
        return VideoDisplay.createVideoDisplay(video, screen);
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, AudioStream audio) {
        JFrame screen = DisplayUtilities.makeFrame((String)"Video");
        return VideoDisplay.createVideoDisplay(video, audio, screen);
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, JFrame screen) {
        return VideoDisplay.createVideoDisplay(video, null, screen);
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, AudioStream as, JFrame screen) {
        DisplayUtilities.ImageComponent ic = new DisplayUtilities.ImageComponent();
        ic.setSize(video.getWidth(), video.getHeight());
        ic.setPreferredSize(new Dimension(video.getWidth(), video.getHeight()));
        ic.setAllowZoom(false);
        ic.setAllowPanning(false);
        ic.setTransparencyGrid(false);
        ic.setShowPixelColours(false);
        ic.setShowXYPosition(false);
        screen.getContentPane().add((Component)ic);
        screen.pack();
        screen.setVisible(true);
        VideoDisplay<T> dv = new VideoDisplay<T>(video, as, ic);
        new Thread(dv).start();
        return dv;
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, DisplayUtilities.ImageComponent ic) {
        VideoDisplay<T> dv = new VideoDisplay<T>(video, ic);
        new Thread(dv).start();
        return dv;
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createOffscreenVideoDisplay(Video<T> video) {
        VideoDisplay<T> dv = new VideoDisplay<T>(video, null);
        dv.displayMode = false;
        new Thread(dv).start();
        return dv;
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, JComponent comp) {
        DisplayUtilities.ImageComponent ic = new DisplayUtilities.ImageComponent();
        ic.setSize(video.getWidth(), video.getHeight());
        ic.setPreferredSize(new Dimension(video.getWidth(), video.getHeight()));
        ic.setAllowZoom(false);
        ic.setAllowPanning(false);
        ic.setTransparencyGrid(false);
        ic.setShowPixelColours(false);
        ic.setShowXYPosition(false);
        comp.add((Component)ic);
        VideoDisplay<T> dv = new VideoDisplay<T>(video, ic);
        new Thread(dv).start();
        return dv;
    }

    public static <T extends Image<?, T>> VideoDisplay<T> createVideoDisplay(Video<T> video, AudioStream audio, JComponent comp) {
        DisplayUtilities.ScalingImageComponent ic;
        if (video.getWidth() > comp.getPreferredSize().width || video.getHeight() > comp.getPreferredSize().height) {
            ic = new DisplayUtilities.ScalingImageComponent();
            ic.setSize(comp.getSize());
            ic.setPreferredSize(comp.getPreferredSize());
        } else {
            ic = new DisplayUtilities.ImageComponent();
            ic.setSize(video.getWidth(), video.getHeight());
            ic.setPreferredSize(new Dimension(video.getWidth(), video.getHeight()));
        }
        ic.setAllowZoom(false);
        ic.setAllowPanning(false);
        ic.setTransparencyGrid(false);
        ic.setShowPixelColours(false);
        ic.setShowXYPosition(false);
        comp.add((Component)ic);
        VideoDisplay<T> dv = new VideoDisplay<T>(video, audio, (DisplayUtilities.ImageComponent)ic);
        new Thread(dv).start();
        return dv;
    }

    public void displayMode(boolean b) {
        this.displayMode = b;
    }

    public void seek(long toSeek) {
        if (this.timeKeeper.supportsSeek()) {
            this.timeKeeper.seek(toSeek);
            this.video.seek(toSeek);
        } else {
            System.out.println("WARNING: Time keeper does not support seek. Not seeking");
        }
    }

    public double getPosition() {
        long nFrames = this.video.countFrames();
        if (nFrames == -1L) {
            return 0.0;
        }
        return (double)this.video.getCurrentFrameIndex() * 100.0 / (double)nFrames;
    }

    public void setPosition(double pc) {
        if (pc > 100.0 || pc < 0.0) {
            throw new IllegalArgumentException("Percentage must be less than or equals to 100 and greater than or equal 0. Given " + pc);
        }
        if (this.video.countFrames() == -1L) {
            return;
        }
        double nMillis = (double)this.video.countFrames() * this.video.getFPS();
        long msPos = (long)(nMillis * pc / 100.0);
        System.out.println("msPOs = " + msPos + " (" + pc + "%)");
        this.seek(msPos);
    }

    public double getDisplayFPS() {
        return this.calculatedFPS;
    }

    public void setTimeKeeper(TimeKeeper<? extends Timecode> t) {
        this.timeKeeper = t;
    }

    public int getDroppedFrameCount() {
        return this.droppedFrameCount;
    }

    public void resetDroppedFrameCount() {
        this.droppedFrameCount = 0;
    }

    public boolean isCalculateFPS() {
        return this.calculateFPS;
    }

    public void setCalculateFPS(boolean calculateFPS) {
        this.calculateFPS = calculateFPS;
    }

    public class BasicVideoTimeKeeper
    implements TimeKeeper<Timecode> {
        private long currentTime = 0L;
        private long lastStarted = 0L;
        private long pausedAt = -1L;
        private long timeOffset = 0L;
        private boolean isRunning = false;
        private HrsMinSecFrameTimecode timecode = null;
        private boolean liveVideo = false;

        public BasicVideoTimeKeeper(boolean liveVideo) {
            this.timecode = new HrsMinSecFrameTimecode(0L, VideoDisplay.this.video.getFPS());
            this.liveVideo = liveVideo;
        }

        public void run() {
            if (this.lastStarted == 0L) {
                this.lastStarted = System.currentTimeMillis();
            } else if (this.supportsPause()) {
                this.timeOffset += System.currentTimeMillis() - this.pausedAt;
            }
            this.isRunning = true;
        }

        public void stop() {
            this.isRunning = false;
            this.currentTime = 0L;
        }

        public Timecode getTime() {
            if (this.isRunning) {
                this.currentTime = System.currentTimeMillis() - this.lastStarted - this.timeOffset;
                this.timecode.setTimecodeInMilliseconds(this.currentTime);
            }
            return this.timecode;
        }

        public boolean supportsPause() {
            return !this.liveVideo;
        }

        public boolean supportsSeek() {
            return !this.liveVideo;
        }

        public void seek(long timestamp) {
            if (!this.liveVideo) {
                this.lastStarted = System.currentTimeMillis() - timestamp;
            }
        }

        public void reset() {
            this.lastStarted = 0L;
            this.pausedAt = -1L;
            this.run();
        }

        public void pause() {
            if (!this.liveVideo) {
                this.isRunning = false;
                this.pausedAt = System.currentTimeMillis();
            }
        }

        public void setTimeOffset(long timeOffset) {
            this.timeOffset = timeOffset;
        }
    }

    public static enum EndAction {
        STOP_AT_END,
        PAUSE_AT_END,
        LOOP,
        CLOSE_AT_END;

    }

    public static enum Mode {
        PLAY,
        PAUSE,
        STOP,
        SEEK,
        CLOSED;

    }
}

