/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.xuggle;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.Global;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.video.VideoWriter;

public class XuggleVideoWriter
extends VideoWriter<MBFImage> {
    private IMediaWriter writer = null;
    private String filename = "output.mp4";
    private long nextFrameTime = 0L;
    private long interFrameTime = 400L;

    public XuggleVideoWriter(String filename, int width, int height, double frameRate) {
        super(width, height, frameRate);
        this.filename = filename;
        this.initialise();
        long sd = (long)(1000.0 / frameRate);
        this.interFrameTime = Global.DEFAULT_TIME_UNIT.convert(sd, TimeUnit.MILLISECONDS);
    }

    public void initialise() {
        if (this.writer == null) {
            this.writer = ToolFactory.makeWriter((String)this.filename);
            this.writer.addVideoStream(0, 0, this.width, this.height);
            this.nextFrameTime = 0L;
        }
    }

    public void processingComplete() {
        this.close();
    }

    public void close() {
        this.writer.close();
    }

    public void addFrame(MBFImage frame) {
        BufferedImage f = ImageUtilities.createBufferedImage((Image)frame);
        f = XuggleVideoWriter.convertToType(f, 5);
        this.writer.encodeVideo(0, f, this.nextFrameTime, Global.DEFAULT_TIME_UNIT);
        this.nextFrameTime += this.interFrameTime;
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    public void reset() {
    }
}

