/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.xuggle;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.URLProtocolManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.timecode.AudioTimecode;
import org.openimaj.video.xuggle.JarURLProtocolHandlerFactory;

public class XuggleAudio
extends AudioStream {
    static Logger logger = Logger.getLogger(XuggleAudio.class);
    private IMediaReader reader = null;
    private int streamIndex = -1;
    private SampleChunk currentSamples = null;
    private boolean chunkAvailable = false;
    private final AudioTimecode currentTimecode = new AudioTimecode(0L);
    private long length = -1L;
    private final String url;
    private final boolean loop;
    private boolean constructedFromStream = false;

    public XuggleAudio(File file) {
        this(file.toURI().toString(), false);
    }

    public XuggleAudio(File file, boolean loop) {
        this(file.toURI().toString(), loop);
    }

    public XuggleAudio(URL u) {
        this(u.toString(), false);
    }

    public XuggleAudio(URL u, boolean loop) {
        this(u.toString(), loop);
    }

    public XuggleAudio(String url) {
        this(url, false);
    }

    public XuggleAudio(String u, boolean loop) {
        this.url = u;
        this.loop = loop;
        this.create(null);
    }

    public XuggleAudio(InputStream stream) {
        this.url = "stream://local";
        this.loop = false;
        this.constructedFromStream = true;
        this.create(stream);
    }

    private void create(InputStream stream) {
        if (this.reader != null && this.reader.isOpen()) {
            this.reader.close();
            this.reader = null;
        }
        IContainer container = null;
        int openResult = 0;
        try {
            container = IContainer.make();
            if (stream != null) {
                openResult = container.open(stream, null, true, true);
                if (openResult < 0) {
                    logger.info((Object)"XuggleAudio could not open InputStream to audio.");
                }
            } else {
                URI uri = new URI(this.url);
                openResult = container.open(uri.toString(), IContainer.Type.READ, null, true, true);
                if (openResult < 0) {
                    logger.trace((Object)("URL " + this.url + " could not be opened by ffmpeg. Trying to open a stream to the URL instead."));
                    InputStream is = uri.toURL().openStream();
                    openResult = container.open(is, null, true, true);
                    if (openResult < 0) {
                        logger.error((Object)("Error opening container. Error " + openResult + " (" + IError.errorNumberToType((int)openResult).toString() + ")"));
                        return;
                    }
                } else {
                    logger.info((Object)("Opened XuggleAudio stream ok: " + openResult));
                }
            }
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            return;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.reader = ToolFactory.makeReader((IContainer)container);
        this.reader.addListener((IMediaListener)new ChunkGetter());
        this.reader.setCloseOnEofOnly(!this.loop);
        IStream s = null;
        for (int i = 0; i < container.getNumStreams(); ++i) {
            s = container.getStream((long)i);
            if (s == null || s.getStreamCoder().getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            this.streamIndex = i;
            break;
        }
        logger.info((Object)("Using audio stream " + this.streamIndex));
        this.length = container.getDuration() == Global.NO_PTS ? -1L : (long)((double)s.getDuration() * s.getTimeBase().getDouble() * 1000.0);
        IStreamCoder aAudioCoder = container.getStream((long)this.streamIndex).getStreamCoder();
        logger.info((Object)("Using stream code: " + aAudioCoder));
        AudioFormat af = new AudioFormat((int)IAudioSamples.findSampleBitDepth((IAudioSamples.Format)aAudioCoder.getSampleFormat()), (double)aAudioCoder.getSampleRate() / 1000.0, aAudioCoder.getChannels());
        af.setSigned(true);
        af.setBigEndian(false);
        this.format = af;
        logger.info((Object)("XuggleAudio using audio format: " + af));
        this.currentSamples = new SampleChunk(af.clone());
    }

    public SampleChunk nextSampleChunk() {
        try {
            IError e = null;
            while ((e = this.reader.readPacket()) == null && !this.chunkAvailable) {
            }
            if (!this.chunkAvailable) {
                this.reader.close();
                this.reader = null;
                return null;
            }
            if (e != null) {
                this.reader.close();
                this.reader = null;
                return null;
            }
            this.chunkAvailable = false;
            return this.currentSamples;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void reset() {
        if (this.constructedFromStream) {
            logger.info((Object)"Cannot reset a stream of audio.");
            return;
        }
        if (this.reader == null || this.reader.getContainer() == null) {
            this.create(null);
        } else {
            this.seek(0L);
        }
    }

    public long getLength() {
        return this.length;
    }

    public void seek(long timestamp) {
        if (this.constructedFromStream) {
            logger.info((Object)"Cannot seek within a stream of audio.");
            return;
        }
        if (this.reader == null || this.reader.getContainer() == null) {
            this.create(null);
        }
        double timebase = this.reader.getContainer().getStream((long)this.streamIndex).getTimeBase().getDouble();
        long position = (long)((double)timestamp / timebase);
        long min = Math.max(0L, position - 100L);
        long max = position;
        int i = this.reader.getContainer().seekKeyFrame(this.streamIndex, min, position, max, 0);
        if (i < 0) {
            logger.error((Object)("Audio seek error (" + i + "): " + IError.errorNumberToType((int)i)));
        } else {
            this.nextSampleChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.reader != null) {
            IMediaReader iMediaReader = this.reader;
            synchronized (iMediaReader) {
                if (this.reader.isOpen()) {
                    this.reader.close();
                    this.reader = null;
                }
            }
        }
    }

    static {
        URLProtocolManager.getManager().registerFactory("jar", (IURLProtocolHandlerFactory)new JarURLProtocolHandlerFactory());
    }

    protected class ChunkGetter
    extends MediaToolAdapter {
        protected ChunkGetter() {
        }

        public void onAudioSamples(IAudioSamplesEvent event) {
            IAudioSamples aSamples = event.getAudioSamples();
            byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
            XuggleAudio.this.currentSamples.setSamples(rawBytes);
            long timestampMillisecs = TimeUnit.MILLISECONDS.convert(event.getTimeStamp(), event.getTimeUnit());
            XuggleAudio.this.currentTimecode.setTimecodeInMilliseconds(timestampMillisecs);
            XuggleAudio.this.currentSamples.setStartTimecode(XuggleAudio.this.currentTimecode);
            XuggleAudio.this.currentSamples.getFormat().setNumChannels(XuggleAudio.this.getFormat().getNumChannels());
            XuggleAudio.this.currentSamples.getFormat().setSigned(XuggleAudio.this.getFormat().isSigned());
            XuggleAudio.this.currentSamples.getFormat().setBigEndian(XuggleAudio.this.getFormat().isBigEndian());
            XuggleAudio.this.currentSamples.getFormat().setSampleRateKHz(XuggleAudio.this.getFormat().getSampleRateKHz());
            XuggleAudio.this.chunkAvailable = true;
        }
    }
}

