/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.OptionsPanel;
import com.salelder.PreviewPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openimaj.video.capture.Device;

public class PreviewController
implements ChangeListener,
ActionListener,
ItemListener {
    private PreviewPanel preview;
    private OptionsPanel options;

    public PreviewController(PreviewPanel p, OptionsPanel o) {
        this.preview = p;
        this.options = o;
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.preview.setOpacity(this.options.getOpacity());
        this.preview.setBrightness(this.options.getBrightness());
        this.preview.setContrast(this.options.getContrast());
        this.preview.setScale(this.options.getScale());
        this.preview.setPanX(this.options.getPanX());
        this.preview.setPanY(this.options.getPanY());
        this.preview.setColorTemp(this.options.getColorTemp());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.preview.toggleView();
    }

    public void toggleOpacity() {
        if (!this.preview.hasReference()) {
            return;
        }
        if (this.preview.getOpacity() == 1.0f) {
            this.preview.setOpacity(0.0f);
        } else {
            this.preview.setOpacity(1.0f);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0 != null && arg0.getStateChange() != 1) {
            return;
        }
        Device d = this.options.getWebcam();
        this.preview.setWebcam(d, this.options.getVideoWidth(), this.options.getVideoHeight());
    }
}

