/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.License;
import com.salelder.LoadImageListener;
import com.salelder.PreviewController;
import com.salelder.PreviewPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.VideoCapture;

public class OptionsPanel
extends JPanel {
    private static int FIELD_WIDTH = 10;
    private JButton loadButton;
    private JButton viewButton;
    private JButton edgeButton;
    private JComboBox<String> webcamSelector;
    private JSlider opacitySlider;
    private JSlider brightnessSlider;
    private JSlider contrastSlider;
    private JSlider scaleSlider;
    private JSlider panXSlider;
    private JSlider panYSlider;
    private JSlider tempSlider;
    private JSpinner camWidth;
    private JSpinner camHeight;
    private PreviewPanel preview;
    private PreviewController previewController;
    private LoadImageListener loadListener;
    private List<Device> camList;
    private JButton refresh;
    public JFileChooser fileChooser;
    private License license;

    public OptionsPanel(PreviewPanel p, License l) {
        this.setLayout(new BoxLayout(this, 3));
        this.preview = p;
        this.license = l;
        this.previewController = new PreviewController(this.preview, this);
        this.fileChooser = new JFileChooser();
        this.loadButton = new JButton("Add reference image");
        this.loadListener = new LoadImageListener(this.preview, this, this.license);
        this.loadButton.addActionListener(this.loadListener);
        this.viewButton = new JButton("Toggle view");
        this.viewButton.addActionListener(this.previewController);
        this.edgeButton = new JButton("Edge detection on/off");
        this.edgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsPanel.this.preview.toggleEdges();
            }
        });
        this.webcamSelector = new JComboBox();
        this.updateWebcams();
        this.webcamSelector.addItemListener(this.previewController);
        this.opacitySlider = new JSlider(0, 100);
        this.opacitySlider.addChangeListener(this.previewController);
        this.brightnessSlider = new JSlider(0, 300, 100);
        this.brightnessSlider.addChangeListener(this.previewController);
        this.contrastSlider = new JSlider(0, 300, 100);
        this.contrastSlider.addChangeListener(this.previewController);
        this.tempSlider = new JSlider(2000, 20000, 6500);
        this.tempSlider.addChangeListener(this.previewController);
        this.scaleSlider = new JSlider(50, 300, 100);
        this.scaleSlider.addChangeListener(this.previewController);
        this.panXSlider = new JSlider(-75, 75, 0);
        this.panXSlider.addChangeListener(this.previewController);
        this.panYSlider = new JSlider(-75, 75, 0);
        this.panYSlider.addChangeListener(this.previewController);
        this.refresh = new JButton("Refresh webcam list");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.updateWebcams();
            }
        });
        this.camWidth = new JSpinner(new SpinnerNumberModel(PreviewPanel.VIDEO_WIDTH, 200, 2000, 10));
        this.camHeight = new JSpinner(new SpinnerNumberModel(PreviewPanel.VIDEO_HEIGHT, 200, 2000, 10));
        ChangeListener camSizeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OptionsPanel.this.preview.setWebcam(OptionsPanel.this.getWebcam(), (Integer)OptionsPanel.this.camWidth.getValue(), (Integer)OptionsPanel.this.camHeight.getValue());
            }
        };
        this.camWidth.addChangeListener(camSizeListener);
        this.camHeight.addChangeListener(camSizeListener);
        this.add(this.loadButton);
        this.add(this.viewButton);
        this.add(this.edgeButton);
        this.add(new JLabel("Opacity"));
        this.add(this.opacitySlider);
        this.add(this.webcamSelector);
        this.add(this.refresh);
        this.add(new JLabel("Brightness"));
        this.add(this.brightnessSlider);
        this.add(new JLabel("Contrast"));
        this.add(this.contrastSlider);
        this.add(new JLabel("Color temperature"));
        this.add(this.tempSlider);
        this.add(new JLabel("Scale"));
        this.add(this.scaleSlider);
        this.add(new JLabel("Pan X"));
        this.add(this.panXSlider);
        this.add(new JLabel("Pan Y"));
        this.add(this.panYSlider);
        this.add(new JLabel("Webcam dimensions: "));
        this.add(this.camWidth);
        this.add(this.camHeight);
    }

    public PreviewController getPreviewController() {
        return this.previewController;
    }

    public void toggleOpacity() {
        this.previewController.toggleOpacity();
        this.opacitySlider.setValue((int)(100.0f * this.preview.getOpacity()));
    }

    public float getOpacity() {
        return 0.01f * (float)this.opacitySlider.getValue();
    }

    public float getBrightness() {
        return 0.01f * (float)this.brightnessSlider.getValue();
    }

    public float getContrast() {
        return 0.01f * (float)this.contrastSlider.getValue();
    }

    public float getScale() {
        return 0.01f * (float)this.scaleSlider.getValue();
    }

    public float getPanX() {
        return 0.01f * (float)this.panXSlider.getValue();
    }

    public float getPanY() {
        return 0.01f * (float)this.panYSlider.getValue();
    }

    public float getColorTemp() {
        return this.tempSlider.getValue();
    }

    public int getVideoWidth() {
        return (Integer)this.camWidth.getValue();
    }

    public int getVideoHeight() {
        return (Integer)this.camHeight.getValue();
    }

    public void setParams(float brightness, float contrast, float scale, float panX, float panY, double temp, int videoWidth, int videoHeight) {
        this.brightnessSlider.setValue((int)(brightness * 100.0f));
        this.contrastSlider.setValue((int)(contrast * 100.0f));
        this.scaleSlider.setValue((int)(scale * 100.0f));
        this.panXSlider.setValue((int)(panX * 100.0f));
        this.panYSlider.setValue((int)(panY * 100.0f));
        this.tempSlider.setValue((int)temp);
        this.previewController.stateChanged(null);
        this.camWidth.setValue(videoWidth);
        this.camHeight.setValue(videoHeight);
        this.previewController.itemStateChanged(null);
    }

    public void updateWebcams() {
        this.camList = VideoCapture.getVideoDevices();
        this.webcamSelector.removeAllItems();
        for (Device d : this.camList) {
            this.webcamSelector.addItem(d.getIdentifierStr());
        }
    }

    public Device getWebcam() {
        int k = this.webcamSelector.getSelectedIndex();
        return this.camList.get(k);
    }
}

