/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.DemoImage;
import com.salelder.License;
import com.salelder.OptionsPanel;
import com.salelder.PreviewPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.plaf.metal.MetalIconFactory;

public class LoadImageListener
implements ActionListener {
    private PreviewPanel preview;
    private OptionsPanel options;
    private License license;
    private DemoImage[] demoImages;

    public LoadImageListener(PreviewPanel p, OptionsPanel o, License l) {
        this.preview = p;
        this.options = o;
        this.license = l;
        String[] demoFilenames = new String[]{"dog.jpg", "liberty.jpg", "monalisa.jpg", "tajmahal.jpg"};
        String[] demoDigests = new String[]{"9cf06be505cba7b5f792da7285aabed2", "ccd71d9538dfe1e7128ab26cf0ad51bf", "95b1b31e75690d391e194f7171427fd4", "54acfcf6e7227b4fd2481d4375f98adb"};
        String[] demoNames = new String[]{"Dog", "Statue of Liberty", "Mona Lisa", "Taj Mahal"};
        this.demoImages = new DemoImage[demoFilenames.length];
        int k = 0;
        while (k < this.demoImages.length) {
            this.demoImages[k] = new DemoImage(demoFilenames[k], demoDigests[k], demoNames[k]);
            ++k;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.license.isActive()) {
            this.openAnyFile();
        } else {
            this.openDemoFile();
        }
    }

    public void openDemoFile() {
        DemoImage selected = (DemoImage)JOptionPane.showInputDialog(this.options, "Select a reference image from the list provided.\nIn the paid version, you can add your own images.", "Select reference image", 3, MetalIconFactory.getFileChooserListViewIcon(), this.demoImages, this.demoImages[0]);
        this.preview.setReferenceImageWithoutFile(selected.getMBFImage());
    }

    public void openAnyFile() {
        if (this.options.fileChooser.showOpenDialog(this.options) == 0) {
            File selectedFile = this.options.fileChooser.getSelectedFile();
            try {
                this.preview.setReference(selectedFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.options, "Couldn't open file.\nTry closing other applications which may be using it.", "File error", 0);
                return;
            }
        }
    }
}

