/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.FileUser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileListener
implements ActionListener {
    public static int OPEN_DIALOG = 0;
    public static int SAVE_DIALOG = 1;
    public static int SAVE_AS_DIALOG = 2;
    private FileNameExtensionFilter filter;
    private JFileChooser fileChooser;
    private Component uiParent;
    private int dialogType;
    private FileUser app;

    public FileListener(FileNameExtensionFilter ext, JFileChooser jfc, Component p, int dt, FileUser a) {
        this.filter = ext;
        this.fileChooser = jfc;
        this.uiParent = p;
        this.dialogType = dt;
        this.app = a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.dialogType == OPEN_DIALOG) {
            this.fileChooser.setFileFilter(this.filter);
            if (this.fileChooser.showOpenDialog(this.uiParent) != 0) return;
            this.app.openFile(this.fileChooser.getSelectedFile());
            return;
        } else if (this.dialogType == SAVE_DIALOG && this.app.hasActiveFile()) {
            this.app.saveFile();
            return;
        } else {
            this.fileChooser.setFileFilter(this.filter);
            if (this.fileChooser.showSaveDialog(this.uiParent) != 0) return;
            File selected = this.fileChooser.getSelectedFile();
            if (this.fileChooser.getFileFilter() == this.filter && !this.filter.accept(selected)) {
                String newName = String.valueOf(selected.getAbsolutePath()) + "." + this.filter.getExtensions()[0];
                selected = new File(newName);
            }
            this.app.saveFile(selected);
        }
    }
}

