/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Pair;
import org.openjena.riot.out.NodeFormatterNT;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.RiotChars;

public class NodeFormatterTTL
extends NodeFormatterNT {
    private final NodeToLabel nodeToLabel = NodeToLabel.createBNodeByLabelEncoded();
    private final PrefixMap prefixMap;
    private final String baseIRI;
    private static int relFlags = 9;
    private static final String dtDecimal = XSDDatatype.XSDdecimal.getURI();
    private static final String dtInteger = XSDDatatype.XSDinteger.getURI();
    private static final String dtDouble = XSDDatatype.XSDdouble.getURI();
    private static final String dtBoolean = XSDDatatype.XSDboolean.getURI();

    public NodeFormatterTTL(String baseIRI, PrefixMap prefixMap) {
        super(false);
        if (prefixMap == null) {
            prefixMap = new PrefixMap();
        }
        this.prefixMap = prefixMap;
        this.baseIRI = baseIRI;
    }

    @Override
    public void formatURI(Writer w, String uriStr) {
        try {
            String x;
            Pair<String, String> pName = this.prefixMap.abbrev(uriStr);
            if (pName != null) {
                String pref = pName.getLeft();
                String ln = pName.getRight();
                if (NodeFormatterTTL.safeForPrefix(pref) && NodeFormatterTTL.safeForPrefixLocalname(ln)) {
                    w.write(pName.getLeft());
                    w.write(58);
                    w.write(pName.getRight());
                    return;
                }
            }
            if (this.baseIRI != null && (x = NodeFormatterTTL.abbrevByBase(uriStr, this.baseIRI)) != null) {
                w.write(60);
                w.write(x);
                w.write(62);
                return;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        super.formatURI(w, uriStr);
    }

    private static String abbrevByBase(String uri, String base) {
        if (base == null) {
            return null;
        }
        IRI baseIRI = IRIFactory.jenaImplementation().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }

    static boolean safeForPrefix(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_BASE(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT(str2, idx)) == -1) {
            return false;
        }
        if (idx == N) {
            return true;
        }
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS(str2, idx)) == -1) {
            return false;
        }
        return idx == N;
    }

    static boolean safeForPrefixLocalname(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_U_or_029(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT(str2, idx)) == -1) {
            return false;
        }
        if (idx == N) {
            return true;
        }
        return (idx = NodeFormatterTTL.skip1_PN_CHARS(str2, idx)) == N;
    }

    private static boolean is_PN_CHARS_BASE(int ch) {
        return RiotChars.isAlpha(ch);
    }

    private static boolean is_PN_CHARS_U(int ch) {
        return NodeFormatterTTL.is_PN_CHARS_BASE(ch) || ch == 95;
    }

    private static boolean is_PN_CHARS(int ch) {
        return NodeFormatterTTL.is_PN_CHARS_U(ch) || ch == 45 || RiotChars.isDigit(ch) || NodeFormatterTTL.isCharsExtra(ch);
    }

    public static boolean isCharsExtra(int ch) {
        return ch == 183 || RiotChars.range(ch, '\u0300', '\u036f') || RiotChars.range(ch, '\u203f', '\u2040');
    }

    private static int skip1_PN_CHARS_U_or_029(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS_U(ch)) {
            return idx + 1;
        }
        if (RiotChars.isDigit(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skip1_PN_CHARS_BASE(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS_BASE(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skipAny_PN_CHARS_or_DOT(String str2, int idx) {
        int N = str2.length();
        for (int i = idx; i < N; ++i) {
            char ch = str2.charAt(i);
            if (NodeFormatterTTL.is_PN_CHARS(ch) || ch == '.') continue;
            return i;
        }
        return N;
    }

    private static int skip1_PN_CHARS(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (NodeFormatterTTL.is_PN_CHARS(ch)) {
            return idx + 1;
        }
        return -1;
    }

    @Override
    public void formatLitDT(Writer w, String lex, String datatypeURI) {
        try {
            if (dtDecimal.equals(datatypeURI)) {
                if (NodeFormatterTTL.validDecimal(lex)) {
                    w.write(lex);
                    return;
                }
            } else if (dtInteger.equals(datatypeURI) && NodeFormatterTTL.validInteger(lex)) {
                w.write(lex);
                return;
            }
            if (dtDouble.equals(datatypeURI) && NodeFormatterTTL.validDouble(lex)) {
                w.write(lex);
                return;
            }
            if (dtBoolean.equals(datatypeURI) && (lex.equals("true") || lex.equals("false"))) {
                w.write(lex);
                return;
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        super.formatLitDT(w, lex, datatypeURI);
    }

    private static boolean validInteger(String lex) {
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDecimal(String lex) {
        int N = lex.length();
        if (N <= 1) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        if ((idx = NodeFormatterTTL.skipDigits(lex, idx)) >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch != '.') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDouble(String lex) {
        int idx2;
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        boolean initialDigits = (idx = NodeFormatterTTL.skipSign(lex, idx)) != (idx2 = NodeFormatterTTL.skipDigits(lex, idx));
        idx = idx2;
        if (idx >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch == '.') {
            if (++idx >= N) {
                return false;
            }
            idx2 = NodeFormatterTTL.skipDigits(lex, idx);
            boolean trailingDigits = idx != idx2;
            idx = idx2;
            if (idx >= N) {
                return false;
            }
            if (!initialDigits && !trailingDigits) {
                return false;
            }
        }
        if ((ch = lex.charAt(idx)) != 'e' && ch != 'E') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipSign(lex, idx)) >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static int skipDigits(String str2, int start) {
        int N = str2.length();
        for (int i = start; i < N; ++i) {
            char ch = str2.charAt(i);
            if (RiotChars.isDigit(ch)) continue;
            return i;
        }
        return N;
    }

    private static int skipSign(String str2, int idx) {
        int N = str2.length();
        char ch = str2.charAt(idx);
        if (ch == '+' || ch == '-') {
            return idx + 1;
        }
        return idx;
    }
}

