/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.openjena.atlas.json.io.parser.TokenizerJSON;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.lang.LangBase;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

public class LangRDFJSON
extends LangBase<Triple> {
    public LangRDFJSON(Tokenizer tokenizer, ParserProfile profile, Sink<Triple> sink) {
        super(tokenizer, profile, sink);
        if (!(tokenizer instanceof TokenizerJSON)) {
            throw new IllegalArgumentException("Tokenizer for the RDF/JSON parser must be an instance of org.openjena.atlas.json.io.parser.TokenizerJSON");
        }
    }

    @Override
    public Lang getLang() {
        return Lang.RDFJSON;
    }

    @Override
    protected void runParser() {
        this.tryParseGraph();
    }

    private void tryParseGraph() {
        if (this.lookingAt(TokenType.LBRACE)) {
            this.nextToken();
            this.tryParseTriples();
            if (!this.lookingAt(TokenType.RBRACE)) {
                this.exception(this.peekToken(), "Expected a } character to end a JSON Object but got %s", this.peekToken());
            }
            this.nextToken();
            if (!this.lookingAt(TokenType.EOF)) {
                this.exception(this.peekToken(), "Expected the end of the JSON but there is additional content beyond the end of the JSON Object", new Object[0]);
            }
            this.nextToken();
        } else {
            this.exception(this.peekToken(), "Expected a { character to start a JSON Object but got %s", this.peekToken());
        }
    }

    private void tryParseTriples() {
        boolean subjectExpected = false;
        while (this.moreTokens()) {
            if (this.lookingAt(TokenType.RBRACE)) {
                if (subjectExpected) {
                    this.exception(this.peekToken(), "Expected a Property Name after a comma to represent the Subject of the next block of triples but got %s", this.peekToken());
                }
                return;
            }
            if (this.isPropertyName()) {
                subjectExpected = false;
                Token t = this.nextToken();
                Node subj = t.getImage().startsWith("_:") ? this.profile.createBlankNode(null, t.getImage().substring(2), t.getLine(), t.getColumn()) : this.profile.createURI(t.getImage(), t.getLine(), t.getColumn());
                this.checkColon();
                this.tryParsePredicateObjectList(subj);
                if (!this.lookingAt(TokenType.COMMA)) continue;
                this.nextToken();
                subjectExpected = true;
                continue;
            }
            if (subjectExpected) {
                this.exception(this.peekToken(), "Expected a Property Name after a comma to represent the Subject of the next block of triples but got %s", this.peekToken());
                continue;
            }
            this.exception(this.peekToken(), "Expected either the end of the JSON Object (the } character) or a JSON Property Name (String) to set the Subject for some Triples but got %s", this.peekToken());
        }
    }

    private void tryParsePredicateObjectList(Node subj) {
        if (!this.lookingAt(TokenType.LBRACE)) {
            this.exception(this.peekToken(), "Expected a { character to start the JSON Object for a Predicate Object List but got a %s", this.peekToken());
        }
        this.nextToken();
        boolean first = true;
        boolean propertyNameExpected = true;
        while (true) {
            if (this.isPropertyName()) {
                first = false;
                propertyNameExpected = false;
                Token t = this.nextToken();
                Node pred = this.profile.createURI(t.getImage(), t.getLine(), t.getColumn());
                this.checkColon();
                this.tryParseObjectList(subj, pred);
                if (!this.lookingAt(TokenType.COMMA)) continue;
                this.nextToken();
                propertyNameExpected = true;
                continue;
            }
            if (!first && this.lookingAt(TokenType.RBRACE)) {
                if (propertyNameExpected) {
                    this.exception(this.peekToken(), "Expected a further Property Name to represent a Predicate after a comma in a Predicate Object List but got %s", this.peekToken());
                }
                this.nextToken();
                return;
            }
            if (propertyNameExpected) {
                this.exception(this.peekToken(), "Expected a Property Name to represent a Predicate as part of a Predicate Object List but got %s", this.peekToken());
                continue;
            }
            this.exception(this.peekToken(), "Expected a Property Name or the end of the Predicate Object List but got %s", this.peekToken());
        }
    }

    private void tryParseObjectList(Node subj, Node pred) {
        if (this.lookingAt(TokenType.LBRACKET)) {
            this.nextToken();
            boolean first = true;
            boolean objectExpected = true;
            while (true) {
                if (this.lookingAt(TokenType.LBRACE)) {
                    if (!objectExpected) {
                        this.exception(this.peekToken(), "Expected the end of the JSON Array for the Object List as no comma was seen after the preceding } but got %s", this.peekToken());
                    }
                    first = false;
                    objectExpected = false;
                    Node obj = this.tryParseObject();
                    Triple t = this.profile.createTriple(subj, pred, obj, this.currLine, this.currCol);
                    this.sink.send(t);
                    if (!this.lookingAt(TokenType.COMMA)) continue;
                    this.nextToken();
                    objectExpected = true;
                    continue;
                }
                if (!first && this.lookingAt(TokenType.RBRACKET)) {
                    if (objectExpected) {
                        this.exception(this.peekToken(), "Expected a further JSON Object to represent an Object after a comma in a Object List but got %s", this.peekToken());
                    }
                    this.nextToken();
                    return;
                }
                if (objectExpected) {
                    this.exception(this.peekToken(), "Expected a JSON Object to represent an Object as part of a Object List but got %s", this.peekToken());
                    continue;
                }
                this.exception(this.peekToken(), "Expected a JSON Object or the end of the Object List but got %s", this.peekToken());
            }
        }
        this.exception(this.peekToken(), "Expected a [ character to start a JSON Array for the Object List but got %s", this.peekToken());
    }

    private Node tryParseObject() {
        Node obj = null;
        Token value = null;
        Token type = null;
        Token lang = null;
        Token datatype = null;
        if (this.lookingAt(TokenType.LBRACE)) {
            String typeStr;
            this.nextToken();
            boolean first = true;
            boolean propertyNameExpected = true;
            while (true) {
                if (this.isPropertyName()) {
                    first = false;
                    propertyNameExpected = false;
                    Token t = this.nextToken();
                    String name = t.getImage();
                    this.checkColon();
                    if (name.equals("value")) {
                        if (value == null) {
                            value = this.checkValidForObjectProperty();
                        } else {
                            this.exception(t, "Encountered the value property on an Object when the value property has already been specified", new Object[0]);
                        }
                    } else if (name.equals("type")) {
                        if (type == null) {
                            type = this.checkValidForObjectProperty();
                        } else {
                            this.exception(t, "Encountered the type property on an Object when the type property has already been specified", new Object[0]);
                        }
                    } else if (name.equals("lang") || name.equals("xml:lang")) {
                        if (lang == null && datatype == null) {
                            lang = this.checkValidForObjectProperty();
                        } else {
                            this.exception(t, "Encountered the %s property on an Object when lang/datatype has already been specified", name);
                        }
                    } else if (name.equals("datatype")) {
                        if (lang == null && datatype == null) {
                            datatype = this.checkValidForObjectProperty();
                        } else {
                            this.exception(t, "Encountered the %s property on an Object when lang/datatype has already been specified", name);
                        }
                    } else {
                        this.exception(t, "Unexpected Property Name %s encountered, expected one of value, type, lang or datatype", t.getImage());
                    }
                    if (!this.lookingAt(TokenType.COMMA)) continue;
                    this.nextToken();
                    propertyNameExpected = true;
                    continue;
                }
                if (!first && this.lookingAt(TokenType.RBRACE)) {
                    if (!propertyNameExpected) break;
                    this.exception(this.peekToken(), "Expected a further Property Name to represent a property of the Object of a Triple after a comma but got %s", this.peekToken());
                    break;
                }
                this.exception(this.peekToken(), "Expected a Property Name to define a property relating to the Object of a Triple but got %s", this.peekToken());
            }
            this.nextToken();
            if (type == null) {
                this.exception(this.peekToken(), "Unable to parse the Object for a Triple from a JSON Object as the required 'type' property is not present", new Object[0]);
            }
            if (value == null) {
                this.exception(this.peekToken(), "Unable to parse the Object for a Triple from a JSON Object as the required 'value' property is not present", new Object[0]);
            }
            if ((typeStr = type.getImage()).equals("uri")) {
                obj = this.profile.createURI(value.getImage(), value.getLine(), value.getColumn());
            } else if (typeStr.equals("bnode")) {
                obj = this.profile.createBlankNode(null, value.getImage().substring(2), value.getLine(), value.getColumn());
            } else if (typeStr.equals("literal")) {
                obj = lang != null ? this.profile.createLangLiteral(value.getImage(), lang.getImage(), value.getLine(), value.getColumn()) : (datatype != null ? this.profile.createTypedLiteral(value.getImage(), TypeMapper.getInstance().getSafeTypeByName(datatype.getImage()), value.getLine(), value.getColumn()) : this.profile.createPlainLiteral(value.getImage(), value.getLine(), value.getColumn()));
            } else {
                this.exception(type, "Unable to parse the Object for a Triple from a JSON Object as the value %s given for the 'type' property is not one of uri, bnode or literal", typeStr);
            }
        } else {
            this.exception(this.peekToken(), "Expected a { character to start a JSON Object to represent the Object of a Triple but got %s", this.peekToken());
        }
        return obj;
    }

    private boolean isPropertyName() {
        return this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2);
    }

    private Token checkValidForObjectProperty() {
        Token t = null;
        if (this.lookingAt(TokenType.STRING1) || this.lookingAt(TokenType.STRING2)) {
            t = this.nextToken();
        } else {
            this.exception(this.peekToken(), "JSON Values given for properties for an Object must be Strings", new Object[0]);
        }
        return t;
    }

    private void checkColon() {
        if (!this.lookingAt(TokenType.COLON)) {
            this.exception(this.peekToken(), "Expected a : character after a JSON Property Name but got %s", this.peekToken());
        }
        this.nextToken();
    }
}

