/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.TSVInputIterator;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.openjena.atlas.io.IO;
import org.openjena.riot.RiotException;

public class TSVInput {
    static Pattern pattern = Pattern.compile("\t");

    public static ResultSet fromTSV(InputStream in) {
        ArrayList<String> varNames;
        ArrayList<Var> vars;
        BufferedReader reader;
        block7: {
            reader = IO.asBufferedUTF8(in);
            vars = new ArrayList<Var>();
            varNames = new ArrayList<String>();
            String str2 = null;
            try {
                String[] tokens2;
                str2 = reader.readLine();
                if (str2 == null) {
                    throw new ARQException("TSV Results malformed - input is empty (no header row)");
                }
                if (str2.isEmpty()) break block7;
                for (String token : tokens2 = pattern.split(str2, -1)) {
                    Node v;
                    try {
                        v = NodeFactory.parseNode(token);
                        if (v == null || !v.isVariable()) {
                            throw new ResultSetException("TSV Results malformed - not a variable: " + token);
                        }
                    }
                    catch (RiotException ex) {
                        throw new ResultSetException("TSV Results malformed - variable names must begin with a ? in the header: " + token);
                    }
                    Var var = Var.alloc(v);
                    vars.add(var);
                    varNames.add(var.getName());
                }
            }
            catch (IOException ex) {
                throw new ARQException(ex);
            }
        }
        return new ResultSetStream(varNames, null, new TSVInputIterator(reader, vars));
    }
}

