/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerException;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.lang.reflect.Method;
import java.util.List;
import org.openjena.atlas.logging.Log;
import org.slf4j.LoggerFactory;

public class DatasetAssembler
extends AssemblerBase
implements Assembler {
    public static Resource getType() {
        return DatasetAssemblerVocab.tDataset;
    }

    public Object open(Assembler a, Resource root, Mode mode) {
        Dataset ds = this.createDataset(a, root, mode);
        this.createTextIndex(ds, root);
        return ds;
    }

    public Dataset createDataset(Assembler a, Resource root, Mode mode) {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        AssemblerUtils.setContext(root, dsg.getContext());
        Dataset ds = DatasetFactory.create(dsg);
        Resource dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pDefaultGraph);
        if (dftGraph == null) {
            dftGraph = GraphUtils.getResourceValue(root, DatasetAssemblerVocab.pGraph);
        }
        Model dftModel = null;
        dftModel = dftGraph != null ? a.openModel(dftGraph) : GraphFactory.makePlainModel();
        ds.setDefaultModel(dftModel);
        List<RDFNode> nodes = GraphUtils.multiValue(root, DatasetAssemblerVocab.pNamedGraph);
        for (RDFNode n : nodes) {
            if (!(n instanceof Resource)) {
                throw new DatasetAssemblerException(root, "Not a resource: " + FmtUtils.stringForRDFNode(n));
            }
            Resource r = (Resource)n;
            String gName = GraphUtils.getAsStringValue(r, DatasetAssemblerVocab.pGraphName);
            Resource g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraph);
            if (g == null) {
                g = GraphUtils.getResourceValue(r, DatasetAssemblerVocab.pGraphAlt);
                if (g != null) {
                    Log.warn((Object)this, "Use of old vocabulary: use :graph not :graphData");
                } else {
                    throw new DatasetAssemblerException(root, "no graph for: " + gName);
                }
            }
            Model m = a.openModel(g);
            ds.addNamedModel(gName, m);
        }
        return ds;
    }

    public Object createTextIndex(Dataset ds, Resource root) {
        Object result = this.createTextIndex(ds, root, "org.apache.jena.larq.assembler.AssemblerLARQ");
        if (result == null) {
            result = this.createTextIndex(ds, root, "com.hp.hpl.jena.query.larq.AssemblerLARQ");
        }
        return result;
    }

    protected Object createTextIndex(Dataset ds, Resource root, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (root.hasProperty(DatasetAssemblerVocab.pIndex)) {
                try {
                    Log.info(DatasetAssembler.class, "Initializing LARQ");
                    String index = GraphUtils.getAsStringValue(root, DatasetAssemblerVocab.pIndex);
                    Class[] paramTypes = new Class[]{Dataset.class, String.class};
                    Method method = clazz.getDeclaredMethod("make", paramTypes);
                    Object[] args = new Object[]{ds, index};
                    return method.invoke(clazz, args);
                }
                catch (Exception e2) {
                    String msg = e2.getMessage() != null ? e2.getMessage() : e2.getCause().getMessage();
                    Log.warn(DatasetAssembler.class, String.format("Unable to initialize LARQ using %s: %s", className, msg));
                }
            }
        }
        catch (ClassNotFoundException e3) {
            LoggerFactory.getLogger(DatasetAssembler.class).debug("LARQ initialization: class " + className + " not in the classpath.");
        }
        return null;
    }
}

