/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.table.TableData;
import com.hp.hpl.jena.sparql.core.DatasetDescription;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.QueryCompare;
import com.hp.hpl.jena.sparql.core.QueryHashCode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.serializer.Serializer;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.PatternVars;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.Printable;
import org.openjena.atlas.logging.Log;

public class Query
extends Prologue
implements Cloneable,
Printable {
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;
    private List<String> graphURIs = new ArrayList<String>();
    private List<String> namedGraphURIs = new ArrayList<String>();
    private Element queryPattern = null;
    private Syntax syntax = Syntax.syntaxSPARQL;
    public static final long NOLIMIT = Long.MIN_VALUE;
    private long resultLimit = Long.MIN_VALUE;
    private long resultOffset = Long.MIN_VALUE;
    private List<SortCondition> orderBy = null;
    public static final int ORDER_ASCENDING = 1;
    public static final int ORDER_DESCENDING = -1;
    public static final int ORDER_DEFAULT = -2;
    public static final int ORDER_UNKNOW = -3;
    protected TableData valuesDataBlock = null;
    protected boolean strictQuery = true;
    protected boolean queryResultStar = false;
    protected boolean distinct = false;
    protected boolean reduced = false;
    protected Template constructTemplate = null;
    protected List<Node> resultNodes = new ArrayList<Node>();
    private VarAlloc varAlloc = new VarAlloc(".");
    protected VarExprList projectVars = new VarExprList();
    protected VarExprList groupVars = new VarExprList();
    protected List<Expr> havingExprs = new ArrayList<Expr>();
    private List<ExprAggregator> aggregators = new ArrayList<ExprAggregator>();
    private Map<Var, ExprAggregator> aggregatorsMap = new HashMap<Var, ExprAggregator>();
    private Map<String, Var> aggregatorsAllocated = new HashMap<String, Var>();
    private boolean resultVarsSet = false;
    private int hashcode = -1;

    public Query() {
        this.syntax = Syntax.syntaxSPARQL;
    }

    public Query(Prologue prologue) {
        this();
        this.usePrologueFrom(prologue);
    }

    private Var allocInternVar() {
        return this.varAlloc.allocVar();
    }

    public void setQuerySelectType() {
        this.queryType = 111;
    }

    public void setQueryConstructType() {
        this.queryType = 222;
        this.queryResultStar = true;
    }

    public void setQueryDescribeType() {
        this.queryType = 333;
    }

    public void setQueryAskType() {
        this.queryType = 444;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public void setStrict(boolean isStrict) {
        this.strictQuery = isStrict;
        if (this.strictQuery) {
            this.initStrict();
        } else {
            this.initLax();
        }
    }

    public boolean isStrict() {
        return this.strictQuery;
    }

    private void initStrict() {
    }

    private void initLax() {
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setReduced(boolean b) {
        this.reduced = b;
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public void setSyntax(Syntax syntax) {
        this.syntax = syntax;
        if (syntax != Syntax.syntaxSPARQL) {
            this.strictQuery = false;
        }
    }

    public long getLimit() {
        return this.resultLimit;
    }

    public void setLimit(long limit) {
        this.resultLimit = limit;
    }

    public boolean hasLimit() {
        return this.resultLimit != Long.MIN_VALUE;
    }

    public long getOffset() {
        return this.resultOffset;
    }

    public void setOffset(long offset) {
        this.resultOffset = offset;
    }

    public boolean hasOffset() {
        return this.resultOffset != Long.MIN_VALUE;
    }

    public boolean hasOrderBy() {
        return this.orderBy != null && this.orderBy.size() > 0;
    }

    public boolean isOrdered() {
        return this.hasOrderBy();
    }

    public void addOrderBy(SortCondition condition) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<SortCondition>();
        }
        this.orderBy.add(condition);
    }

    public void addOrderBy(Expr expr, int direction) {
        SortCondition sc = new SortCondition(expr, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(Node var, int direction) {
        if (!var.isVariable()) {
            throw new QueryException("Not a variable: " + var);
        }
        SortCondition sc = new SortCondition(var, direction);
        this.addOrderBy(sc);
    }

    public void addOrderBy(String varName, int direction) {
        varName = Var.canonical(varName);
        SortCondition sc = new SortCondition(new ExprVar(varName), direction);
        this.addOrderBy(sc);
    }

    public List<SortCondition> getOrderBy() {
        return this.orderBy;
    }

    public boolean isQueryResultStar() {
        return this.queryResultStar;
    }

    public void setQueryResultStar(boolean isQueryStar) {
        this.queryResultStar = isQueryStar;
    }

    public void setQueryPattern(Element elt) {
        this.queryPattern = elt;
    }

    public Element getQueryPattern() {
        return this.queryPattern;
    }

    public void addGraphURI(String s) {
        if (this.graphURIs == null) {
            this.graphURIs = new ArrayList<String>();
        }
        this.graphURIs.add(s);
    }

    public void addNamedGraphURI(String uri) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        if (this.namedGraphURIs.contains(uri)) {
            throw new QueryException("URI already in named graph set: " + uri);
        }
        this.namedGraphURIs.add(uri);
    }

    public List<String> getGraphURIs() {
        return this.graphURIs;
    }

    public boolean usesGraphURI(String uri) {
        return this.graphURIs.contains(uri);
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean usesNamedGraphURI(String uri) {
        return this.namedGraphURIs.contains(uri);
    }

    public boolean hasDatasetDescription() {
        if (this.getGraphURIs() != null && this.getGraphURIs().size() > 0) {
            return true;
        }
        return this.getNamedGraphURIs() != null && this.getNamedGraphURIs().size() > 0;
    }

    public DatasetDescription getDatasetDescription() {
        DatasetDescription description = new DatasetDescription();
        if (!this.hasDatasetDescription()) {
            return description;
        }
        description.addAllDefaultGraphURIs(this.getGraphURIs());
        description.addAllNamedGraphURIs(this.getNamedGraphURIs());
        return description;
    }

    public List<String> getResultVars() {
        this.setResultVars();
        return Var.varNames(this.projectVars.getVars());
    }

    public List<Var> getProjectVars() {
        this.setResultVars();
        return this.projectVars.getVars();
    }

    public VarExprList getProject() {
        return this.projectVars;
    }

    public void addProjectVars(Collection<?> vars) {
        for (Object obj : vars) {
            if (obj instanceof String) {
                this.addResultVar((String)obj);
                continue;
            }
            if (obj instanceof Var) {
                this.addResultVar((Node)((Var)((Object)obj)));
                continue;
            }
            throw new QueryException("Not a variable or variable name: " + obj);
        }
        this.resultVarsSet = true;
    }

    public void addResultVar(String varName) {
        varName = Var.canonical(varName);
        this._addResultVar(varName);
    }

    public void addResultVar(Node v) {
        if (!v.isVariable()) {
            throw new QueryException("Not a variable: " + v);
        }
        this._addResultVar(v.getName());
    }

    public void addResultVar(Node v, Expr expr) {
        Var var = null;
        if (v == null) {
            var = this.allocInternVar();
        } else {
            if (!v.isVariable()) {
                throw new QueryException("Not a variable: " + v);
            }
            var = Var.alloc(v);
        }
        Query._addVarExpr(this.projectVars, var, expr);
    }

    public void addResultVar(Expr expr) {
        Query._addVarExpr(this.projectVars, this.allocInternVar(), expr);
    }

    public void addResultVar(String varName, Expr expr) {
        Var var = null;
        if (varName == null) {
            var = this.allocInternVar();
        } else {
            varName = Var.canonical(varName);
            var = Var.alloc(varName);
        }
        Query._addVarExpr(this.projectVars, var, expr);
    }

    private void _addResultVar(String varName) {
        Var v = Var.alloc(varName);
        Query._addVar(this.projectVars, v);
        this.resultVarsSet = true;
    }

    private static void _addVar(VarExprList varExprList, Var v) {
        if (varExprList.contains(v)) {
            Expr expr = varExprList.getExpr(v);
            if (expr != null) {
                throw new QueryBuildException("Duplicate variable (had an expression) in result projection '" + (Object)((Object)v) + "'");
            }
            return;
        }
        varExprList.add(v);
    }

    private static void _addVarExpr(VarExprList varExprList, Var v, Expr expr) {
        if (varExprList.contains(v)) {
            throw new QueryBuildException("Duplicate variable in result projection '" + (Object)((Object)v) + "'");
        }
        varExprList.add(v, expr);
    }

    public boolean hasGroupBy() {
        return !this.groupVars.isEmpty() || this.getAggregators().size() > 0;
    }

    public boolean hasHaving() {
        return this.havingExprs != null && this.havingExprs.size() > 0;
    }

    public VarExprList getGroupBy() {
        return this.groupVars;
    }

    public List<Expr> getHavingExprs() {
        return this.havingExprs;
    }

    public void addGroupBy(String varName) {
        varName = Var.canonical(varName);
        this.addGroupBy((Node)Var.alloc(varName));
    }

    public void addGroupBy(Node v) {
        Query._addVar(this.groupVars, Var.alloc(v));
    }

    public void addGroupBy(Expr expr) {
        this.addGroupBy(null, expr);
    }

    public void addGroupBy(Var v, Expr expr) {
        if (v == null) {
            v = this.allocInternVar();
        }
        if (expr.isVariable() && v.isAllocVar()) {
            this.addGroupBy((Node)expr.asVar());
            return;
        }
        this.groupVars.add(v, expr);
    }

    public void addHavingCondition(Expr expr) {
        this.havingExprs.add(expr);
    }

    public boolean hasAggregators() {
        return this.aggregators.size() != 0;
    }

    public List<ExprAggregator> getAggregators() {
        return this.aggregators;
    }

    public Expr allocAggregate(Aggregator agg) {
        String key = agg.key();
        Var v = this.aggregatorsAllocated.get(key);
        if (v != null) {
            ExprAggregator eAgg = this.aggregatorsMap.get((Object)v);
            if (!((Object)agg).equals(eAgg.getAggregator())) {
                Log.warn(Query.class, "Internal inconsistency: Aggregator: " + agg);
            }
            return eAgg;
        }
        v = this.allocInternVar();
        ExprAggregator aggExpr = new ExprAggregator(v, agg);
        this.aggregatorsAllocated.put(key, v);
        this.aggregatorsMap.put(v, aggExpr);
        this.aggregators.add(aggExpr);
        return aggExpr;
    }

    public boolean hasValues() {
        return this.valuesDataBlock != null;
    }

    public List<Var> getValuesVariables() {
        return this.valuesDataBlock == null ? null : this.valuesDataBlock.getVars();
    }

    public List<Binding> getValuesData() {
        return this.valuesDataBlock == null ? null : this.valuesDataBlock.getRows();
    }

    public void setValuesDataBlock(List<Var> variables, List<Binding> values) {
        Query.checkDataBlock(variables, values);
        this.valuesDataBlock = new TableData(variables, values);
    }

    private static void checkDataBlock(List<Var> variables, List<Binding> values) {
        int N = variables.size();
        for (Binding valueRow : values) {
            Iterator<Var> iter = valueRow.vars();
            while (iter.hasNext()) {
                Var v = iter.next();
                if (variables.contains((Object)v)) continue;
                throw new QueryBuildException("Variable " + (Object)((Object)v) + " not found in " + variables);
            }
        }
    }

    public Template getConstructTemplate() {
        return this.constructTemplate;
    }

    public void setConstructTemplate(Template templ) {
        this.constructTemplate = templ;
    }

    public void addDescribeNode(Node node) {
        if (node.isVariable()) {
            this.addResultVar(node);
            return;
        }
        if (node.isURI() || node.isBlank()) {
            if (!this.resultNodes.contains(node)) {
                this.resultNodes.add(node);
            }
            return;
        }
        if (node.isLiteral()) {
            throw new QueryException("Result node is a literal: " + FmtUtils.stringForNode(node));
        }
        throw new QueryException("Result node not recognized: " + node);
    }

    public List<Node> getResultURIs() {
        return this.resultNodes;
    }

    public void setResultVars() {
        if (this.resultVarsSet) {
            return;
        }
        this.resultVarsSet = true;
        if (this.getQueryPattern() == null) {
            if (!this.isDescribeType()) {
                Log.warn(this, "setResultVars(): no query pattern");
            }
            return;
        }
        if (this.isSelectType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
        if (this.isConstructType()) {
            this.findAndAddNamedVars();
            return;
        }
        if (this.isDescribeType()) {
            if (this.isQueryResultStar()) {
                this.findAndAddNamedVars();
            }
            return;
        }
    }

    private void findAndAddNamedVars() {
        Iterator<Var> varIter = null;
        if (this.hasGroupBy()) {
            varIter = this.groupVars.getVars().iterator();
        } else {
            LinkedHashSet<Var> queryVars = new LinkedHashSet<Var>();
            PatternVars.vars(queryVars, this.getQueryPattern());
            if (this.hasValues()) {
                queryVars.addAll(this.getValuesVariables());
            }
            varIter = queryVars.iterator();
        }
        while (varIter.hasNext()) {
            Var obj = varIter.next();
            Var var = obj;
            if (!var.isNamedVar()) continue;
            this.addResultVar((Node)var);
        }
    }

    public void visit(QueryVisitor visitor) {
        visitor.startVisit(this);
        visitor.visitResultForm(this);
        visitor.visitPrologue(this);
        if (this.isSelectType()) {
            visitor.visitSelectResultForm(this);
        }
        if (this.isConstructType()) {
            visitor.visitConstructResultForm(this);
        }
        if (this.isDescribeType()) {
            visitor.visitDescribeResultForm(this);
        }
        if (this.isAskType()) {
            visitor.visitAskResultForm(this);
        }
        visitor.visitDatasetDecl(this);
        visitor.visitQueryPattern(this);
        visitor.visitGroupBy(this);
        visitor.visitHaving(this);
        visitor.visitOrderBy(this);
        visitor.visitOffset(this);
        visitor.visitLimit(this);
        visitor.visitValues(this);
        visitor.finishVisit(this);
    }

    public Object clone() {
        return this.cloneQuery();
    }

    public Query cloneQuery() {
        return this.cloneQuery(false);
    }

    public Query cloneQuery(boolean useRawQuery) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff, this.getSyntax());
        String qs = buff.toString();
        return QueryFactory.create(qs, this.getSyntax());
    }

    public String toString() {
        return this.serialize();
    }

    public String toString(Syntax syntax) {
        return this.serialize(syntax);
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = QueryHashCode.calc(this);
            if (this.hashcode == -1) {
                this.hashcode = -1073741824;
            }
        }
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Query)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return QueryCompare.equals(this, (Query)other);
    }

    @Override
    public void output(IndentedWriter out) {
        this.serialize(out);
    }

    public String serialize() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff);
        return buff.toString();
    }

    public String serialize(Syntax syntax) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.serialize(buff, syntax);
        return buff.toString();
    }

    public void serialize(OutputStream out) {
        Serializer.serialize(this, out);
    }

    public void serialize(OutputStream out, Syntax syntax) {
        Serializer.serialize(this, out, syntax);
    }

    public void serialize(IndentedLineBuffer buff) {
        Serializer.serialize(this, buff);
    }

    public void serialize(IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(this, buff, outSyntax);
    }

    public void serialize(IndentedWriter writer) {
        Serializer.serialize(this, writer);
    }

    public void serialize(IndentedWriter writer, Syntax outSyntax) {
        Serializer.serialize(this, writer, outSyntax);
    }

    static {
        ARQ.init();
    }
}

