/*
 * Decompiled with CFR 0.152.
 */
package jal.floats;

import jal.floats.BinaryOperator;

public final class Numeric {
    public static float accumulate(float[] array, int first, int last, float init) {
        float acc = init;
        while (first < last) {
            acc += array[first++];
        }
        return acc;
    }

    public static float accumulate(float[] array, int first, int last, float init, BinaryOperator op) {
        float acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static float inner_product(float[] array1, float[] array2, int first1, int last1, int first2, float init) {
        float acc = init;
        while (first1 < last1) {
            acc += array1[first1++] * array2[first2++];
        }
        return acc;
    }

    public static float inner_product(float[] array1, float[] array2, int first1, int last1, int first2, float init, BinaryOperator op1, BinaryOperator op2) {
        float acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(float[] source, float[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            float value = dest[to];
            while (++first < last) {
                dest[++to] = value += source[first];
            }
            return to + 1;
        }
        return to;
    }

    public static int partial_sum(float[] source, float[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            float value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(float[] source, float[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            float prev_value = source[first];
            while (++first < last) {
                float cur_value = source[first];
                dest[++to] = cur_value - prev_value;
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(float[] source, float[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            float prev_value = source[first];
            while (++first < last) {
                float cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

