/*
 * Decompiled with CFR 0.152.
 */
package jal.floats;

import jal.floats.BinaryPredicate;
import jal.floats.Predicate;
import jal.floats.VoidFunction;

public final class Inspection {
    public static void for_each(float[] array, int first, int last, VoidFunction f) {
        while (first < last) {
            f.apply(array[first++]);
        }
    }

    public static int adjacent_find(float[] array, int first, int last) {
        int next = first;
        while (++next < last) {
            if (array[first] == array[next]) {
                return first;
            }
            first = next;
        }
        return last;
    }

    public static int adjacent_find(float[] array, int first, int last, BinaryPredicate p) {
        int next = first;
        while (++next < last) {
            if (p.apply(array[first], array[next])) {
                return first;
            }
            first = next;
        }
        return last;
    }

    public static int find(float[] array, int first, int last, float x) {
        while (first < last && x != array[first]) {
            ++first;
        }
        return first;
    }

    public static int find_not(float[] array, int first, int last, float x) {
        while (first < last && x == array[first]) {
            ++first;
        }
        return first;
    }

    public static int find_if(float[] array, int first, int last, Predicate p) {
        while (first < last && !p.apply(array[first])) {
            ++first;
        }
        return first;
    }

    public static int find_if_not(float[] array, int first, int last, Predicate p) {
        while (first < last && p.apply(array[first])) {
            ++first;
        }
        return first;
    }

    public static int count_if(float[] array, int first, int last, Predicate p) {
        int counter = 0;
        while (first < last) {
            if (!p.apply(array[first++])) continue;
            ++counter;
        }
        return counter;
    }

    public static int count_if_not(float[] array, int first, int last, Predicate p) {
        int counter = 0;
        while (first < last) {
            if (p.apply(array[first++])) continue;
            ++counter;
        }
        return counter;
    }

    public static int mismatch(float[] array1, float[] array2, int first1, int last1, int first2) {
        while (first1 < last1 && array1[first1] == array2[first2]) {
            ++first1;
            ++first2;
        }
        return first1;
    }

    public static int mismatch(float[] array1, float[] array2, int first1, int last1, int first2, BinaryPredicate p) {
        while (first1 < last1 && p.apply(array1[first1], array2[first2])) {
            ++first1;
            ++first2;
        }
        return first1;
    }

    public static boolean equal(float[] array1, float[] array2, int first1, int last1, int first2) {
        while (first1 < last1 && array1[first1] == array2[first2]) {
            ++first1;
            ++first2;
        }
        return first1 >= last1;
    }

    public static boolean equal(float[] array1, float[] array2, int first1, int last1, int first2, BinaryPredicate p) {
        while (first1 < last1 && p.apply(array1[first1], array2[first2])) {
            ++first1;
            ++first2;
        }
        return first1 >= last1;
    }

    public static int search(float[] array1, float[] array2, int first1, int last1, int first2, int last2) {
        int len1 = last1 - first1;
        int len2 = last2 - first2;
        int cur1 = first1;
        int cur2 = first2;
        if (len1 < len2) {
            return last1;
        }
        while (cur2 < last2) {
            if (array1[cur1++] == array2[cur2++]) continue;
            if (len1 == len2) {
                return last1;
            }
            cur1 = ++first1;
            cur2 = first2;
            --len1;
        }
        return cur2 == last2 ? first1 : last1;
    }

    public static int search(float[] array1, float[] array2, int first1, int last1, int first2, int last2, BinaryPredicate p) {
        int len1 = last1 - first1;
        int len2 = last2 - first2;
        int cur1 = first1;
        int cur2 = first2;
        if (len1 < len2) {
            return last1;
        }
        while (cur2 < last2) {
            if (p.apply(array1[cur1++], array2[cur2++])) continue;
            if (len1 == len2) {
                return last1;
            }
            cur1 = ++first1;
            cur2 = first2;
            --len1;
        }
        return cur2 == last2 ? first1 : last1;
    }

    private Inspection() {
    }
}

