/*
 * Decompiled with CFR 0.152.
 */
package jal.chars;

import jal.chars.BinaryOperator;

public final class Numeric {
    public static char accumulate(char[] array, int first, int last, char init) {
        char acc = init;
        while (first < last) {
            acc = (char)(acc + array[first++]);
        }
        return acc;
    }

    public static char accumulate(char[] array, int first, int last, char init, BinaryOperator op) {
        char acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static char inner_product(char[] array1, char[] array2, int first1, int last1, int first2, char init) {
        char acc = init;
        while (first1 < last1) {
            acc = (char)(acc + array1[first1++] * array2[first2++]);
        }
        return acc;
    }

    public static char inner_product(char[] array1, char[] array2, int first1, int last1, int first2, char init, BinaryOperator op1, BinaryOperator op2) {
        char acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(char[] source, char[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            char value = dest[to];
            while (++first < last) {
                value = (char)(value + source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int partial_sum(char[] source, char[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            char value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(char[] source, char[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            char prev_value = source[first];
            while (++first < last) {
                char cur_value = source[first];
                dest[++to] = (char)(cur_value - prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(char[] source, char[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            char prev_value = source[first];
            while (++first < last) {
                char cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

