/*
 * Decompiled with CFR 0.152.
 */
package jal.shorts;

import jal.shorts.BinaryOperator;

public final class Numeric {
    public static short accumulate(short[] array, int first, int last, short init) {
        short acc = init;
        while (first < last) {
            acc = (short)(acc + array[first++]);
        }
        return acc;
    }

    public static short accumulate(short[] array, int first, int last, short init, BinaryOperator op) {
        short acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static short inner_product(short[] array1, short[] array2, int first1, int last1, int first2, short init) {
        short acc = init;
        while (first1 < last1) {
            acc = (short)(acc + array1[first1++] * array2[first2++]);
        }
        return acc;
    }

    public static short inner_product(short[] array1, short[] array2, int first1, int last1, int first2, short init, BinaryOperator op1, BinaryOperator op2) {
        short acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(short[] source, short[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            short value = dest[to];
            while (++first < last) {
                value = (short)(value + source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int partial_sum(short[] source, short[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            short value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(short[] source, short[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            short prev_value = source[first];
            while (++first < last) {
                short cur_value = source[first];
                dest[++to] = (short)(cur_value - prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(short[] source, short[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            short prev_value = source[first];
            while (++first < last) {
                short cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

