/*
 * Decompiled with CFR 0.152.
 */
package jal.bytes;

import jal.bytes.BinaryOperator;

public final class Numeric {
    public static byte accumulate(byte[] array, int first, int last, byte init) {
        byte acc = init;
        while (first < last) {
            acc = (byte)(acc + array[first++]);
        }
        return acc;
    }

    public static byte accumulate(byte[] array, int first, int last, byte init, BinaryOperator op) {
        byte acc = init;
        while (first < last) {
            acc = op.apply(acc, array[first++]);
        }
        return acc;
    }

    public static byte inner_product(byte[] array1, byte[] array2, int first1, int last1, int first2, byte init) {
        byte acc = init;
        while (first1 < last1) {
            acc = (byte)(acc + array1[first1++] * array2[first2++]);
        }
        return acc;
    }

    public static byte inner_product(byte[] array1, byte[] array2, int first1, int last1, int first2, byte init, BinaryOperator op1, BinaryOperator op2) {
        byte acc = init;
        while (first1 < last1) {
            acc = op1.apply(acc, op2.apply(array1[first1++], array2[first2++]));
        }
        return acc;
    }

    public static int partial_sum(byte[] source, byte[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            byte value = dest[to];
            while (++first < last) {
                value = (byte)(value + source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int partial_sum(byte[] source, byte[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            byte value = dest[to];
            while (++first < last) {
                value = op.apply(value, source[first]);
                dest[++to] = value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(byte[] source, byte[] dest, int first, int last, int to) {
        if (first < last) {
            dest[to] = source[first];
            byte prev_value = source[first];
            while (++first < last) {
                byte cur_value = source[first];
                dest[++to] = (byte)(cur_value - prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    public static int adjacent_difference(byte[] source, byte[] dest, int first, int last, int to, BinaryOperator op) {
        if (first < last) {
            dest[to] = source[first];
            byte prev_value = source[first];
            while (++first < last) {
                byte cur_value = source[first];
                dest[++to] = op.apply(cur_value, prev_value);
                prev_value = cur_value;
            }
            return to + 1;
        }
        return to;
    }

    private Numeric() {
    }
}

