/*
 * Decompiled with CFR 0.152.
 */
package org.arabidopsis.ahocorasick;

import junit.framework.TestCase;
import org.arabidopsis.ahocorasick.State;

public class TestState
extends TestCase {
    public void testSimpleExtension() {
        State s = new State(0);
        State s2 = s.extend("a".getBytes()[0]);
        TestState.assertTrue((s2 != s && s2 != null ? 1 : 0) != 0);
        TestState.assertEquals((int)2, (int)s.size());
    }

    public void testSimpleExtensionSparse() {
        State s = new State(50);
        State s2 = s.extend((byte)3);
        TestState.assertTrue((s2 != s && s2 != null ? 1 : 0) != 0);
        TestState.assertEquals((int)2, (int)s.size());
    }

    public void testSingleState() {
        State s = new State(0);
        TestState.assertEquals((int)1, (int)s.size());
    }

    public void testSingleStateSparse() {
        State s = new State(50);
        TestState.assertEquals((int)1, (int)s.size());
    }

    public void testExtendAll() {
        State s = new State(0);
        s.extendAll("hello world".getBytes());
        TestState.assertEquals((int)12, (int)s.size());
    }

    public void testExtendAllTwiceDoesntAddMoreStates() {
        State s = new State(0);
        State s2 = s.extendAll("hello world".getBytes());
        State s3 = s.extendAll("hello world".getBytes());
        TestState.assertEquals((int)12, (int)s.size());
        TestState.assertTrue((s2 == s3 ? 1 : 0) != 0);
    }

    public void testExtendAllTwiceDoesntAddMoreStatesSparse() {
        State s = new State(50);
        State s2 = s.extendAll("hello world".getBytes());
        State s3 = s.extendAll("hello world".getBytes());
        TestState.assertEquals((int)12, (int)s.size());
        TestState.assertTrue((s2 == s3 ? 1 : 0) != 0);
    }

    public void testAddingALotOfStatesIsOk() {
        State s = new State(0);
        for (int i = 0; i < 256; ++i) {
            s.extend((byte)i);
        }
        TestState.assertEquals((int)257, (int)s.size());
    }

    public void testAddingALotOfStatesIsOkOnSparseRep() {
        State s = new State(50);
        for (int i = 0; i < 256; ++i) {
            s.extend((byte)i);
        }
        TestState.assertEquals((int)257, (int)s.size());
    }
}

