/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.geocode;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.openimaj.text.nlp.geocode.GeonamesIndex;

public class ReverseGeoCode {
    private GeonamesIndex geoindex;
    private String validCodes;

    public ReverseGeoCode() {
        this.geoindex = GeonamesIndex.instance();
        this.validCodes = null;
    }

    public ReverseGeoCode(String ... validCountryCodes) {
        Object[] prefixed = new String[validCountryCodes.length];
        int i = 0;
        for (String vcc : validCountryCodes) {
            prefixed[i++] = "country_code:" + vcc;
        }
        this.validCodes = String.format("(%s)^2", StringUtils.join((Object[])prefixed, (String)" OR "));
    }

    public String countryCode(String raw) {
        try {
            QueryResponse qres = this.geoindex.query(this.constructQuery(raw));
            SolrDocumentList res = qres.getResults();
            return (String)((SolrDocument)res.get(0)).get((Object)"country_code");
        }
        catch (SolrServerException solrServerException) {
            return null;
        }
    }

    private String constructQuery(String raw) {
        String query = "{!type=dismax qf=\"country_code basic_name timezone\" mm=1}";
        if (this.validCodes != null) {
            query = query + this.validCodes + " AND ";
        }
        query = query + raw;
        return query;
    }
}

