/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.geocode;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class GeonamesIndex {
    private static final int N_ROWS = 10;
    private static final String[] DEFAULT_FIELDS = new String[]{"*,score"};
    private static Logger log = LoggerFactory.getLogger(GeonamesIndex.class);
    private static String SOLR_CONFIG = "solrconfig.xml";
    private static String SOLR_SCHEMA = "schema.xml";
    private CoreContainer solrContainer;
    private EmbeddedSolrServer solrIndex;
    private static GeonamesIndex instance;

    private GeonamesIndex() {
        String solrHome = System.getProperty("geonames.solr.home");
        if (solrHome == null) {
            log.error("No 'geonames.solr.home' provided!");
            return;
        }
        File solrDir = new File(solrHome);
        if (solrDir == null || !solrDir.exists() || !solrDir.isDirectory()) {
            log.error("SOLR_HOME does not exist, or is not a directory: '{}'", (Object)solrHome);
            return;
        }
        try {
            this.solrIndex = this.buildSolrIndex(solrHome);
        }
        catch (Exception ex) {
            log.error("\n... Solr failed to load!");
            log.error("Stack trace: ", (Throwable)ex);
            log.error("\n=============");
        }
    }

    public static synchronized GeonamesIndex instance() {
        if (instance == null) {
            instance = new GeonamesIndex();
        }
        return instance;
    }

    private EmbeddedSolrServer buildSolrIndex(String home) throws ParserConfigurationException, IOException, SAXException {
        SolrConfig solrConfig = new SolrConfig(home, SOLR_CONFIG, null);
        IndexSchema schema = new IndexSchema(solrConfig, SOLR_SCHEMA, null);
        this.solrContainer = new CoreContainer(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
        CoreDescriptor descriptor = new CoreDescriptor(this.solrContainer, "", solrConfig.getResourceLoader().getInstanceDir());
        descriptor.setConfigName(solrConfig.getResourceName());
        descriptor.setSchemaName(schema.getResourceName());
        SolrCore solrCore = new SolrCore(null, solrConfig.getDataDir(), solrConfig, schema, descriptor);
        this.solrContainer.register("cheese", solrCore, false);
        return new EmbeddedSolrServer(this.solrContainer, "cheese");
    }

    public QueryResponse query(String query) throws SolrServerException {
        return this.query(query, 10, DEFAULT_FIELDS, null);
    }

    public QueryResponse query(String query, int limit) throws SolrServerException {
        return this.query(query, limit, DEFAULT_FIELDS, null);
    }

    public QueryResponse query(String query, int nRows, String[] fields, String filter) throws SolrServerException {
        SolrQuery q = new SolrQuery();
        q.setQuery(query);
        q.setRows(Integer.valueOf(nRows));
        q.setFields(fields);
        if (filter != null) {
            q.setFilterQueries(new String[]{filter});
        }
        q.setFacet(false);
        return this.solrIndex.query((SolrParams)q);
    }
}

