/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static final String ENCODING_CHARSET = "UTF-8";
    private static final Logger logger = Logger.getLogger(StringUtils.class.getName());

    private StringUtils() {
    }

    public static boolean isBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    public static String trimToNull(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        return string.trim();
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter 'string' cannot be null.");
        }
        try {
            return string.getBytes(ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform doesn't support UTF-8", unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, ENCODING_CHARSET));
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            block10: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        if (!logger.isLoggable(Level.WARNING)) break block10;
                        logger.warning("Unable to close stream, continuing on: " + throwable);
                    }
                }
            }
        }
    }

    public static String join(String[] stringArray) {
        return stringArray == null ? null : StringUtils.join(Arrays.asList(stringArray));
    }

    public static String join(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static Integer toInteger(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

