/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<ClassAnnotationCacheKey, List<?>> FIELDS_WITH_ANNOTATION_CACHE = Collections.synchronizedMap(new HashMap());

    private ReflectionUtils() {
    }

    public static boolean isPrimitive(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        return object instanceof String || object instanceof Integer || Integer.TYPE.equals(clazz) || object instanceof Boolean || Boolean.TYPE.equals(clazz) || object instanceof Long || Long.TYPE.equals(clazz) || object instanceof Double || Double.TYPE.equals(clazz) || object instanceof Float || Float.TYPE.equals(clazz) || object instanceof Byte || Byte.TYPE.equals(clazz) || object instanceof Short || Short.TYPE.equals(clazz) || object instanceof Character || Character.TYPE.equals(clazz);
    }

    public static <T extends Annotation> List<FieldWithAnnotation<T>> findFieldsWithAnnotation(Class<?> clazz, Class<T> clazz2) {
        ClassAnnotationCacheKey classAnnotationCacheKey = new ClassAnnotationCacheKey(clazz, clazz2);
        List<FieldWithAnnotation<T>> list = FIELDS_WITH_ANNOTATION_CACHE.get(classAnnotationCacheKey);
        if (list != null) {
            return list;
        }
        ArrayList<FieldWithAnnotation<T>> arrayList = new ArrayList();
        while (!Object.class.equals(clazz)) {
            for (Field field : clazz.getDeclaredFields()) {
                T t = field.getAnnotation(clazz2);
                if (t == null) continue;
                arrayList.add(new FieldWithAnnotation<T>(field, t));
            }
            clazz = clazz.getSuperclass();
        }
        arrayList = Collections.unmodifiableList(arrayList);
        FIELDS_WITH_ANNOTATION_CACHE.put(classAnnotationCacheKey, arrayList);
        return arrayList;
    }

    public static Class<?> getFirstParameterizedTypeArgument(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        return type2 instanceof Class ? (Class)type2 : null;
    }

    public static List<Method> getAccessors(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The 'clazz' parameter cannot be null.");
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            String string = method.getName();
            if ("getClass".equals(string) || "hashCode".equals(string) || method.getReturnType() == null || Void.class.equals(method.getReturnType()) || method.getParameterTypes().length != 0 || !(string.startsWith("get") && string.length() > 3 || string.startsWith("is") && string.length() > 2) && (!string.startsWith("has") || string.length() <= 3)) continue;
            arrayList.add(method);
        }
        Collections.sort(arrayList, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return method.getName().compareTo(method2.getName());
            }
        });
        return Collections.unmodifiableList(arrayList);
    }

    public static String toString(Object object) {
        StringBuilder stringBuilder = new StringBuilder(object.getClass().getSimpleName());
        stringBuilder.append("[");
        boolean bl = true;
        for (Method method : ReflectionUtils.getAccessors(object.getClass())) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" ");
            }
            try {
                String string = method.getName();
                int n = string.startsWith("is") ? 2 : 3;
                string = string.substring(n, n + 1).toLowerCase() + string.substring(n + 1);
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(method.invoke(object, new Object[0]));
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to reflectively invoke " + method + " on " + object.getClass(), exception);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 17;
        for (Method method : ReflectionUtils.getAccessors(object.getClass())) {
            try {
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) continue;
                n = n * 31 + object2.hashCode();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to reflectively invoke " + method + " on " + object, exception);
            }
        }
        return n;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().isInstance(object2) && !object2.getClass().isInstance(object)) {
            return false;
        }
        HashSet<Method> hashSet = new HashSet<Method>(ReflectionUtils.getAccessors(object.getClass()));
        hashSet.retainAll(ReflectionUtils.getAccessors(object2.getClass()));
        for (Method method : hashSet) {
            try {
                Object object3 = method.invoke(object, new Object[0]);
                Object object4 = method.invoke(object2, new Object[0]);
                if (object3 == null && object4 == null) continue;
                if (object3 == null || object4 == null) {
                    return false;
                }
                if (object3.equals(object4)) continue;
                return false;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to reflectively invoke " + method, exception);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassAnnotationCacheKey {
        private final Class<?> clazz;
        private final Class<? extends Annotation> annotation;

        private ClassAnnotationCacheKey(Class<?> clazz, Class<? extends Annotation> clazz2) {
            this.clazz = clazz;
            this.annotation = clazz2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.annotation == null ? 0 : this.annotation.hashCode());
            n = 31 * n + (this.clazz == null ? 0 : this.clazz.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ClassAnnotationCacheKey classAnnotationCacheKey = (ClassAnnotationCacheKey)object;
            if (this.annotation == null ? classAnnotationCacheKey.annotation != null : !this.annotation.equals(classAnnotationCacheKey.annotation)) {
                return false;
            }
            return !(this.clazz == null ? classAnnotationCacheKey.clazz != null : !this.clazz.equals(classAnnotationCacheKey.clazz));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldWithAnnotation<T extends Annotation> {
        private Field field;
        private T annotation;

        public FieldWithAnnotation(Field field, T t) {
            this.field = field;
            this.annotation = t;
        }

        public Field getField() {
            return this.field;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public String toString() {
            return String.format("Field %s.%s (%s): %s", this.field.getDeclaringClass().getName(), this.field.getName(), this.field.getType(), this.annotation);
        }
    }
}

