/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.util.List;
import java.util.Set;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.MultidimensionalIntFV;
import org.openimaj.image.Image;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.face.detection.CCDetectedFace;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Shape;

public enum FaceDetectorFeatures {
    COUNT{

        @Override
        public <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> faces, T img) {
            return new MultidimensionalIntFV(new int[]{faces.size()}, new int[]{1});
        }
    }
    ,
    BLOBS{

        @Override
        public <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> faces, T img) {
            int[][] fvs = new int[faces.size()][];
            int i = 0;
            for (DetectedFace detectedFace : faces) {
                Set pixels = this.getConnectedComponent((DetectedFace)detectedFace).pixels;
                int[] fv = new int[pixels.size() * 2];
                int j = 0;
                for (Pixel p : pixels) {
                    fv[j++] = p.x;
                    fv[j++] = p.y;
                }
                fvs[i++] = fv;
            }
            return new MultidimensionalIntFV((int[][])fvs);
        }
    }
    ,
    BOX{

        @Override
        public <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> faces, T img) {
            int[][] fvs = new int[faces.size()][];
            int i = 0;
            for (DetectedFace detectedFace : faces) {
                fvs[i++] = new int[]{(int)detectedFace.getBounds().x, (int)detectedFace.getBounds().y, (int)detectedFace.getBounds().width, (int)detectedFace.getBounds().height};
            }
            return new MultidimensionalIntFV((int[][])fvs);
        }
    }
    ,
    ORIBOX{

        @Override
        public <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> faces, T img) {
            int[][] fvs = new int[faces.size()][];
            int i = 0;
            for (DetectedFace detectedFace : faces) {
                Polygon p = this.getConnectedComponent(detectedFace).calculateOrientatedBoundingBox().asPolygon();
                int[] fv = new int[p.getVertices().size() * 2];
                int j = 0;
                int k = 0;
                while (j < fv.length) {
                    fv[j] = (int)((Point2d)p.getVertices().get(k)).getX();
                    fv[j + 1] = (int)((Point2d)p.getVertices().get(k)).getY();
                    j += 2;
                    ++k;
                }
                fvs[i++] = fv;
            }
            return new MultidimensionalIntFV((int[][])fvs);
        }
    }
    ,
    AREA{

        @Override
        public <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> faces, T img) {
            double[] fv = new double[faces.size()];
            double area = img.getWidth() * img.getHeight();
            int i = 0;
            for (DetectedFace detectedFace : faces) {
                fv[i++] = (double)this.getConnectedComponent(detectedFace).calculateArea() / area;
            }
            return new DoubleFV(fv);
        }
    };


    protected ConnectedComponent getConnectedComponent(DetectedFace df) {
        if (df instanceof CCDetectedFace) {
            return ((CCDetectedFace)df).connectedComponent;
        }
        return new ConnectedComponent((Shape)df.getBounds());
    }

    public abstract <T extends Image<?, T>> FeatureVector getFeatureVector(List<? extends DetectedFace> var1, T var2);
}

