/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.owl2java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.openimaj.rdf.owl2java.Generator;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.memory.model.MemBNode;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;

public class PropertyDef {
    private Generator.GeneratorOptions generator;
    protected static HashMap<URI, String> typeMap = new HashMap();
    protected static HashMap<URI, String> importMap = new HashMap();
    protected static HashMap<URI, URL> uriResolveMap = new HashMap();
    protected URI uri;
    protected String comment;
    protected PropertyType type = PropertyType.DATATYPE;
    protected List<URI> range = new ArrayList<URI>();
    protected List<URI> domain = new ArrayList<URI>();
    protected int maxCardinality = Integer.MAX_VALUE;
    protected int minCardinality = Integer.MIN_VALUE;
    protected int absoluteCardinality = -1;

    public PropertyDef(Generator.GeneratorOptions go) {
        try {
            this.generator = (Generator.GeneratorOptions)go.clone();
            this.generator.skipPom = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.uri.getLocalName();
    }

    public List<String> needsImport(boolean implementation) {
        String importReq;
        ArrayList<String> imports = new ArrayList<String>();
        if (this.range.size() == 1 && (importReq = importMap.get(this.range.get(0))) != null) {
            imports.add(importReq);
        }
        if (this.absoluteCardinality != 1) {
            imports.add("java.util.List");
            if (implementation) {
                imports.add("java.util.ArrayList");
            }
        }
        return imports;
    }

    public String getDeclarationType() {
        String valueType = "String";
        if (this.range.size() > 0) {
            if (this.range.size() == 1) {
                URI rangeURI = this.range.get(0);
                if (typeMap.get(rangeURI) != null) {
                    valueType = typeMap.get(rangeURI);
                } else if (uriResolveMap.get(rangeURI) != null) {
                    try {
                        Generator.generate(uriResolveMap.get(rangeURI).openStream(), this.generator);
                    }
                    catch (Exception e) {
                        System.out.println("URL not resolveable");
                    }
                    valueType = Generator.getTypeName(rangeURI);
                } else {
                    valueType = Generator.getTypeName(rangeURI);
                }
            } else {
                valueType = "Object";
            }
        }
        return valueType;
    }

    public String toJavaDefinition(String prefix, boolean generateAnnotations) {
        String valueType = this.getDeclarationType();
        String s = "";
        if (this.comment != null) {
            s = this.comment.length() < 80 ? s + "\n" + prefix + "/** " + this.comment + " */\n" : s + "\n" + prefix + "/** " + WordUtils.wrap((String)this.comment, (int)70).replaceAll("\\r?\\n", "\n" + prefix + "    ") + " */\n";
        }
        if (generateAnnotations) {
            s = s + prefix + "@Predicate(\"" + this.uri + "\")\n";
        }
        s = this.absoluteCardinality == 1 ? s + prefix + "public " + valueType + " " + this.uri.getLocalName() + ";" : s + prefix + "public List<" + valueType + "> " + this.uri.getLocalName() + " = new ArrayList<" + valueType + ">();";
        if (this.comment != null || generateAnnotations) {
            s = s + "\n";
        }
        return s;
    }

    public String toSettersAndGetters(String prefix, boolean implementations, String delegationObject, boolean indexedRatherThanCollections) {
        String valueType = this.getDeclarationType();
        String pName = Generator.getTypeName(this.uri);
        String s = "";
        s = this.absoluteCardinality == 1 ? s + prefix + "public " + valueType + " get" + pName + "()" : (indexedRatherThanCollections ? s + prefix + "public " + valueType + " get" + pName + "( int index )" : s + prefix + "public List<" + valueType + "> get" + pName + "()");
        if (implementations) {
            s = s + "\n";
            s = s + prefix + "{\n";
            s = delegationObject != null && !delegationObject.equals("this") ? (!indexedRatherThanCollections || this.absoluteCardinality == 1 ? s + prefix + "\treturn " + delegationObject + ".get" + pName + "();\n" : s + prefix + "\treturn " + delegationObject + ".get" + pName + "( index );\n") : (!indexedRatherThanCollections || this.absoluteCardinality == 1 ? s + prefix + "\treturn this." + this.uri.getLocalName() + ";\n" : s + prefix + "\treturn this." + this.uri.getLocalName() + ".get(index);\n");
            s = s + prefix + "}\n";
        } else {
            s = s + ";\n";
        }
        s = s + prefix + "\n";
        s = this.absoluteCardinality == 1 ? s + prefix + "public void set" + pName + "( final " + valueType + " " + this.uri.getLocalName() + " )" : (!indexedRatherThanCollections ? s + prefix + "public void set" + pName + "( final List<" + valueType + "> " + this.uri.getLocalName() + " )" : s + prefix + "public void add" + pName + "( final " + valueType + " " + this.uri.getLocalName() + " )");
        if (implementations) {
            s = s + "\n";
            s = s + prefix + "{\n";
            s = delegationObject != null && !delegationObject.equals("this") ? s + prefix + "\t" + delegationObject + ".set" + pName + "( " + this.uri.getLocalName() + " );\n" : s + prefix + "\tthis." + this.uri.getLocalName() + " = " + this.uri.getLocalName() + ";\n";
            s = s + prefix + "}\n";
        } else {
            s = s + ";\n";
        }
        return s;
    }

    static Set<PropertyDef> loadProperties(Generator.GeneratorOptions go, URI uri, RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String query = "prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix owl: <http://www.w3.org/2002/07/owl#> SELECT ?property ?type ?comment ?range ?domain ?listNode WHERE { ?property rdfs:domain <" + uri + ">.   ?property rdf:type ?type.   OPTIONAL { ?property rdfs:comment ?comment .}   OPTIONAL { ?property rdfs:range ?range. }   OPTIONAL { ?property rdfs:domain ?domain. }   OPTIONAL { ?domain owl:unionOf ?listNode. } }";
        TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        TupleQueryResult res = preparedQuery.evaluate();
        HashSet<PropertyDef> properties = new HashSet<PropertyDef>();
        while (res.hasNext()) {
            MemBNode m;
            Value v;
            BindingSet bindingSet = (BindingSet)res.next();
            PropertyDef def = new PropertyDef(go);
            def.uri = (URI)bindingSet.getValue("property");
            if (bindingSet.getValue("type").stringValue().equals("http://www.w3.org/2002/07/owl#ObjectProperty")) {
                def.type = PropertyType.OBJECT;
            } else {
                if (!bindingSet.getValue("type").stringValue().equals("http://www.w3.org/2002/07/owl#DatatypeProperty")) continue;
                def.type = PropertyType.DATATYPE;
            }
            if (bindingSet.getValue("comment") != null) {
                def.comment = bindingSet.getValue("comment").stringValue();
            }
            if (bindingSet.getValue("domain") != null) {
                v = bindingSet.getValue("domain");
                if (v instanceof URI) {
                    def.domain.add((URI)v);
                } else if (v instanceof MemBNode && (m = (MemBNode)bindingSet.getBinding("listNode")) != null) {
                    def.domain.addAll(PropertyDef.getURIListBNode(m));
                }
            }
            if (bindingSet.getValue("range") != null) {
                v = bindingSet.getValue("range");
                if (v instanceof URI) {
                    def.range.add((URI)v);
                } else if (v instanceof MemBNode && (m = (MemBNode)bindingSet.getBinding("listNode")) != null) {
                    def.range.addAll(PropertyDef.getURIListBNode(m));
                }
            }
            properties.add(def);
        }
        res.close();
        return properties;
    }

    protected static List<URI> getURIList(URI listNode, RepositoryConnection conn) {
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            String sparql = "SELECT * WHERE { " + listNode + " rdf:rest*/rdf:first ?value. }";
            TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
            TupleQueryResult res = tq.evaluate();
            while (res.hasNext()) {
                BindingSet bs = (BindingSet)res.next();
                Binding value = bs.getBinding("value");
                if (!(value instanceof URI)) continue;
                uris.add((URI)value);
            }
            res.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
        return uris;
    }

    protected static List<URI> getURIListBNode(MemBNode bNode) {
        ArrayList<URI> list = new ArrayList<URI>();
        PropertyDef.getURIListBNode(bNode, list);
        return list;
    }

    private static void getURIListBNode(MemBNode bNode, List<URI> list) {
        MemStatementList ssl = bNode.getSubjectStatementList();
        MemBNode nextNode = null;
        for (int i = 0; i < ssl.size(); ++i) {
            MemStatement statement = ssl.get(i);
            if (statement.getPredicate().stringValue().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") && statement.getObject() instanceof URI) {
                list.add((URI)statement.getObject());
            }
            if (!statement.getPredicate().stringValue().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") || !(statement.getObject() instanceof MemBNode)) continue;
            nextNode = (MemBNode)statement.getObject();
        }
        if (nextNode != null) {
            PropertyDef.getURIListBNode(nextNode, list);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyDef)) {
            return false;
        }
        return this.uri.equals((Object)((PropertyDef)obj).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static {
        importMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#date"), "org.joda.time.DateTime");
        importMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#dateTime"), "org.joda.time.DateTime");
        typeMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#int"), "Integer");
        typeMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#int"), "Integer");
        typeMap.put((URI)new URIImpl("http://www.w3.org/2000/01/rdf-schema#Literal"), "String");
        typeMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"), "Integer");
        typeMap.put((URI)new URIImpl("http://www.w3.org/2001/XMLSchema#date"), "DateTime");
        try {
            uriResolveMap.put((URI)new URIImpl("http://www.w3.org/2004/03/trix/rdfg-1/Graph"), new URL("http://www.w3.org/2004/03/trix/rdfg-1/Graph"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected static enum PropertyType {
        OBJECT,
        DATATYPE;

    }
}

