/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.owl2java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.openimaj.rdf.owl2java.ClassDef;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class Generator {
    protected static void debugAllTriples(URI uri, RepositoryConnection conn) {
        try {
            String query = "SELECT ?uri ?pred ?obj WHERE { ?uri ?pred ?obj. } ";
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?uri ?pred ?obj WHERE { ?uri ?pred ?obj. } ");
            TupleQueryResult res = preparedQuery.evaluate();
            System.out.println("----------------------------------------------");
            System.out.println("Triples for " + uri);
            System.out.println("----------------------------------------------");
            while (res.hasNext()) {
                BindingSet bindingSet = (BindingSet)res.next();
                System.out.println("( " + bindingSet.getBinding("uri").getValue() + " " + bindingSet.getBinding("pred").getValue() + " " + bindingSet.getBinding("obj").getValue() + " )");
            }
            res.close();
            System.out.println("----------------------------------------------\n");
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
    }

    protected static Map<URI, String> generatePackageMappings(Collection<ClassDef> classes) {
        HashMap<URI, String> packageMapping = new HashMap<URI, String>();
        for (ClassDef cd : classes) {
            if (packageMapping.containsKey(cd.uri)) continue;
            packageMapping.put(cd.uri, Generator.getPackageName(cd.uri));
        }
        return packageMapping;
    }

    protected static String getPackageName(URI uri) {
        return Generator.getPackageName(uri, true);
    }

    protected static String getPackageName(URI uri, boolean removeWWW) {
        String ns = uri.getNamespace();
        if (ns.contains("//")) {
            ns = ns.substring(ns.indexOf("//") + 2);
        }
        if (!ns.contains("/")) {
            return ns;
        }
        String last = ns.substring(ns.indexOf("/") + 1);
        if (last.contains("#")) {
            last = last.substring(0, last.indexOf("#"));
        }
        if (last.contains(".")) {
            last = last.substring(0, last.indexOf("."));
        }
        last = last.replace("/", ".");
        last = last.replace("-", "_");
        String serverName = ns.substring(0, ns.indexOf("/"));
        String[] parts = serverName.split("\\.");
        serverName = "";
        int count = 0;
        for (int i = parts.length - 1; i >= 0; --i) {
            if (parts[i].charAt(0) < 'A' || parts[i].charAt(0) > 'z') {
                serverName = serverName + "_";
            }
            if (removeWWW && parts[i].equals("www")) continue;
            if (count != 0 && i != 0) {
                serverName = serverName + ".";
            }
            serverName = serverName + parts[i];
            ++count;
        }
        String lastBit = "";
        if (last.indexOf(".") == -1) {
            lastBit = last;
        } else {
            for (String s : last.split("\\.")) {
                lastBit = lastBit + ".";
                lastBit = s.charAt(0) < 'A' || s.charAt(0) > 'z' ? lastBit + "_" + s : lastBit + s;
            }
        }
        return serverName + lastBit;
    }

    private static void createPOM(File targetDir, String groupId, String artifactId, String versionNumber, String parentGAV) {
        try {
            String s = Resources.toString((URL)Resources.getResource((String)"pom.xml"), (Charset)Charsets.UTF_8);
            s = Generator.replaceCodes(groupId, artifactId, versionNumber, s);
            if (parentGAV != null) {
                String ps = Resources.toString((URL)Resources.getResource((String)"pom_xml_parent.xml"), (Charset)Charsets.UTF_8);
                String[] splits = parentGAV.split(":");
                ps = Generator.replaceCodes(splits[0], splits[1], splits[2], ps);
                s = s.replaceAll("\\{!p!\\}", ps);
            } else {
                s = s.replaceAll("\\{!p!\\}", "");
            }
            FileUtils.writeStringToFile((File)new File(targetDir, "pom.xml"), (String)s, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String replaceCodes(String groupId, String artifactId, String versionNumber, String s) {
        s = s.replaceAll("\\{!g!\\}", groupId);
        s = s.replaceAll("\\{!a!\\}", artifactId);
        s = s.replaceAll("\\{!v!\\}", versionNumber);
        return s;
    }

    protected static String getTypeName(URI s) {
        return s.getLocalName().substring(0, 1).toUpperCase() + s.getLocalName().substring(1);
    }

    public static void generate(InputStream is, GeneratorOptions go) throws RepositoryException, RDFParseException, IOException, MalformedQueryException, QueryEvaluationException {
        if (go.mavenProject != null && !go.skipPom) {
            Generator.createPOM(new File(go.targetDirectory), go.mavenProject, go.mavenArtifactId, go.mavenVersionNumber, go.mavenParent);
            go.targetDirectory = go.targetDirectory + File.separator + "src" + File.separator + "main" + File.separator + "java";
            new File(go.targetDirectory).mkdirs();
        }
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        repository.initialize();
        RepositoryConnection conn = repository.getConnection();
        conn.add(is, "", RDFFormat.RDFXML, new Resource[0]);
        Map<URI, ClassDef> classes = ClassDef.loadClasses(go, conn);
        Map<URI, String> pkgs = Generator.generatePackageMappings(classes.values());
        for (ClassDef cd : classes.values()) {
            cd.generateInterface(new File(go.targetDirectory), pkgs, classes);
            cd.generateClass(new File(go.targetDirectory), pkgs, classes, go.flattenClassStructure, go.generateAnnotations, go.separateImplementations);
        }
    }

    public static void main(String[] args) throws RepositoryException {
        GeneratorOptions go = new GeneratorOptions();
        CmdLineParser parser = new CmdLineParser((Object)go);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java Generator RDF-FILE TARGET-DIR [options]");
            parser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        File rdfFile = new File(go.rdfFile);
        File targetDir = new File(go.targetDirectory);
        if (!rdfFile.exists()) {
            System.out.println("The RDF file does not exist: " + rdfFile);
            System.exit(1);
        }
        if (!targetDir.exists()) {
            System.out.println("The target directory does not exist: " + targetDir);
            System.exit(1);
        }
        try {
            Generator.generate(new FileInputStream(rdfFile), go);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class GeneratorOptions
    implements Cloneable {
        @Argument(metaVar="RDF-FILE", index=0, usage="The RDF file to convert", required=true)
        public String rdfFile;
        @Argument(metaVar="TARGET-DIR", index=1, usage="The output directory for the generated class files", required=true)
        public String targetDirectory;
        @Option(name="-annotate", aliases={"-a"}, usage="Generate @Predicate annotations")
        public boolean generateAnnotations = true;
        @Option(name="-flatten", aliases={"-f"}, usage="Flatten the properties in the generated classes")
        public boolean flattenClassStructure = false;
        @Option(name="-separate", aliases={"-s"}, usage="Put implementations in a separate package")
        public boolean separateImplementations = true;
        @Option(name="-maven", aliases={"-m"}, usage="Create a Maven project with this groupId", metaVar="GROUP-ID")
        public String mavenProject = null;
        @Option(name="-artifactId", usage="Specify the artifact identifier for the maven project", metaVar="ARTIFACT-ID")
        public String mavenArtifactId = "generated-rdf";
        @Option(name="-version", usage="Specify the version for the maven project", metaVar="VERSION-NUMBER")
        public String mavenVersionNumber = "1.0";
        @Option(name="-mavenParent", aliases={"-p"}, usage="The mavenParent artifact GAV to add to the pom.xml (g:a:v)")
        public String mavenParent = null;
        @Option(name="-skipPom", usage="Skip generation of the maven pom", required=false)
        public boolean skipPom = false;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

