/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.rdf.owl2java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.joda.time.DateTime;
import org.openimaj.rdf.owl2java.Generator;
import org.openimaj.rdf.owl2java.PropertyDef;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.memory.model.MemBNode;
import org.openrdf.sail.memory.model.MemLiteral;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemStatementList;

public class ClassDef {
    protected String comment;
    protected URI uri;
    protected Map<URI, Set<URI>> allSuperclasses;
    protected Set<URI> directSuperclasses;
    protected Set<PropertyDef> properties;

    public String toString() {
        return "class " + this.uri.getLocalName() + " extends " + this.allSuperclasses + " {\n\t" + this.properties + "\n}\n";
    }

    public static Map<URI, ClassDef> loadClasses(Generator.GeneratorOptions go, RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String[] clzTypes;
        HashMap<URI, ClassDef> classes = new HashMap<URI, ClassDef>();
        for (String clzType : clzTypes = new String[]{"<http://www.w3.org/2002/07/owl#Class>", "rdfs:Class"}) {
            String query = "SELECT Class, Comment FROM {Class} rdf:type {" + clzType + "};  [ rdfs:comment {Comment} ]";
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SERQL, query);
            TupleQueryResult res = preparedQuery.evaluate();
            while (res.hasNext()) {
                BindingSet bindingSet = (BindingSet)res.next();
                if (!(bindingSet.getValue("Class") instanceof URI)) continue;
                ClassDef clz = new ClassDef();
                if (bindingSet.getValue("Comment") != null) {
                    MemLiteral lit = (MemLiteral)bindingSet.getValue("Comment");
                    clz.comment = lit.stringValue();
                }
                clz.uri = (URI)bindingSet.getValue("Class");
                clz.directSuperclasses = ClassDef.getSuperclasses(clz.uri, conn);
                clz.properties = PropertyDef.loadProperties(go, clz.uri, conn);
                ClassDef.getEquivalentClasses(clz, conn);
                clz.allSuperclasses = clz.getAllSuperclasses(conn);
                classes.put(clz.uri, clz);
            }
        }
        return classes;
    }

    private static void getEquivalentClasses(ClassDef clz, RepositoryConnection conn) {
        try {
            String sparql = "prefix owl: <http://www.w3.org/2002/07/owl#> SELECT ?clazz WHERE { <" + clz.uri + "> owl:equivalentClass ?clazz . }";
            TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
            TupleQueryResult res = preparedQuery.evaluate();
            while (res.hasNext()) {
                BindingSet bs = (BindingSet)res.next();
                Value clazz = bs.getBinding("clazz").getValue();
                if (clazz instanceof URI) {
                    clz.directSuperclasses.add((URI)clazz);
                    continue;
                }
                if (!(clazz instanceof MemBNode)) continue;
                MemBNode b = (MemBNode)clazz;
                MemStatementList sl = b.getSubjectStatementList();
                for (int i = 0; i < sl.size(); ++i) {
                    MemStatement x = sl.get(i);
                    System.out.println("    -> " + x);
                }
            }
            res.close();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
    }

    private static Set<URI> getSuperclasses(URI uri, RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String query = "SELECT ?superclass WHERE { <" + uri.stringValue() + "> <http://www.w3.org/2000/01/rdf-schema#subClassOf> ?superclass. }";
        TupleQuery preparedQuery = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        TupleQueryResult res = preparedQuery.evaluate();
        HashSet<URI> superclasses = new HashSet<URI>();
        while (res.hasNext()) {
            BindingSet bindingSet = (BindingSet)res.next();
            if (!(bindingSet.getValue("superclass") instanceof URI)) continue;
            superclasses.add((URI)bindingSet.getValue("superclass"));
        }
        return superclasses;
    }

    public void generateClass(File targetDir, Map<URI, String> pkgs, Map<URI, ClassDef> classes, boolean flattenClassStructure, boolean generateAnnotations, boolean separateImplementations) throws FileNotFoundException {
        PrintStream ps;
        File path = new File(targetDir.getAbsolutePath() + File.separator + pkgs.get(this.uri).replace(".", File.separator) + (separateImplementations ? File.separator + "impl" : ""));
        path.mkdirs();
        try {
            ps = new PrintStream(new File(path.getAbsolutePath() + File.separator + Generator.getTypeName(this.uri) + "Impl.java"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        ps.println("package " + pkgs.get(this.uri) + (separateImplementations ? ".impl" : "") + ";");
        ps.println();
        ps.println("import org.openimaj.rdf.owl2java.Something;");
        if (separateImplementations) {
            ps.println("import " + pkgs.get(this.uri) + ".*;");
        }
        if (generateAnnotations) {
            ps.println("import org.openimaj.rdf.serialize.Predicate;\n");
            ps.println("import org.openimaj.rdf.serialize.RDFType;\n");
        }
        this.printImports(ps, pkgs, false, classes, true);
        ps.println();
        this.printClassComment(ps);
        ps.print("@RDFType(\"" + this.uri + "\")\n");
        ps.print("public class " + Generator.getTypeName(this.uri) + "Impl ");
        ps.print("extends Something ");
        ps.print("implements " + Generator.getTypeName(this.uri));
        ps.println("\n{");
        this.printClassPropertyDefinitions(ps, classes, flattenClassStructure, generateAnnotations);
        ps.println("}\n");
    }

    public void generateInterface(File targetDir, Map<URI, String> pkgs, Map<URI, ClassDef> classes) throws FileNotFoundException {
        PrintStream ps;
        File path = new File(targetDir.getAbsolutePath() + File.separator + pkgs.get(this.uri).replace(".", File.separator));
        path.mkdirs();
        try {
            ps = new PrintStream(new File(path.getAbsolutePath() + File.separator + Generator.getTypeName(this.uri) + ".java"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        ps.println("package " + pkgs.get(this.uri) + ";");
        ps.println();
        this.printImports(ps, pkgs, true, classes, false);
        ps.println();
        this.printClassComment(ps);
        ps.print("public interface " + Generator.getTypeName(this.uri) + " ");
        if (this.allSuperclasses.size() > 0) {
            ps.print("\n\textends ");
            boolean first = true;
            for (URI superClassURI : this.directSuperclasses) {
                if (!first) {
                    ps.print(", ");
                }
                ps.print(Generator.getTypeName(superClassURI));
                first = false;
            }
        }
        ps.println("\n{");
        this.printInterfacePropertyDefinitions(ps);
        ps.println("\tpublic String getURI();\n");
        ps.println("}\n");
    }

    private void printClassComment(PrintStream ps) {
        ps.println("/**");
        if (this.comment == null) {
            ps.println(" * " + this.uri);
        } else {
            String cmt = WordUtils.wrap((String)(" * " + this.comment.replaceAll("\\r?\\n", " ")), (int)80, (String)"\n * ", (boolean)false);
            ps.println(" " + cmt);
        }
        ps.println(" *");
        ps.println(" *\t@created " + new DateTime());
        ps.println(" *\t@generated by owl2java from OpenIMAJ");
        ps.println(" */");
    }

    private void printImports(PrintStream ps, Map<URI, String> pkgs, boolean superclasses, Map<URI, ClassDef> classes, boolean implementations) {
        HashSet<String> imports = new HashSet<String>();
        HashMap<PropertyDef, String> pd = new HashMap<PropertyDef, String>();
        HashMap<String, String> instanceNameMap = new HashMap<String, String>();
        this.getFullPropertyList(pd, instanceNameMap, classes);
        for (PropertyDef p : pd.keySet()) {
            if (!implementations && !((String)pd.get(p)).equals("this") || p.needsImport(implementations) == null) continue;
            imports.addAll(p.needsImport(implementations));
        }
        if (superclasses) {
            for (URI u : this.directSuperclasses) {
                imports.add(pkgs.get(u) + ".");
                imports.add(pkgs.get(u) + ".impl.");
            }
        }
        imports.remove(pkgs.get(this.uri) + ".");
        Object[] sortedImports = imports.toArray(new String[imports.size()]);
        Arrays.sort(sortedImports);
        for (Object imp : sortedImports) {
            if (((String)imp).endsWith(".")) {
                ps.println("import " + (String)imp + "*;");
                continue;
            }
            ps.println("import " + (String)imp + ";");
        }
    }

    private void printInterfacePropertyDefinitions(PrintStream ps) {
        for (PropertyDef p : this.properties) {
            ps.println(p.toSettersAndGetters("\t", false, null, false));
        }
    }

    private void printClassPropertyDefinitions(PrintStream ps, Map<URI, ClassDef> classes, boolean flattenClassStructure, boolean generateAnnotations) {
        HashSet<URI> alreadyDone = new HashSet<URI>();
        if (flattenClassStructure) {
            HashSet<PropertyDef> pd = new HashSet<PropertyDef>();
            pd.addAll(this.properties);
            for (Set<URI> superclassList : this.allSuperclasses.values()) {
                for (URI superclass : superclassList) {
                    if (alreadyDone.contains(superclass)) continue;
                    pd.addAll(classes.get((Object)superclass).properties);
                    alreadyDone.add(superclass);
                }
            }
            for (PropertyDef p : pd) {
                ps.println(p.toJavaDefinition("\t", generateAnnotations));
            }
            ps.println();
            for (PropertyDef p : pd) {
                ps.println(p.toSettersAndGetters("\t", true, null, false));
            }
        } else {
            System.out.println("=======================================");
            System.out.println(this.uri);
            System.out.println("=======================================");
            System.out.println("Direct superclasses: " + this.directSuperclasses);
            for (PropertyDef p : this.properties) {
                ps.println(p.toJavaDefinition("\t", generateAnnotations));
            }
            ps.println();
            HashMap pd = new HashMap();
            HashMap<String, String> entityNameMap = new HashMap<String, String>();
            this.getFullPropertyList(pd, entityNameMap, classes);
            HashMap xx = new HashMap();
            xx.putAll(pd);
            HashSet<String> delegatesToOutput = new HashSet<String>();
            Iterator i = xx.values().iterator();
            String xxx = null;
            while (i.hasNext()) {
                xxx = (String)i.next();
                if (xxx.equals("this")) continue;
                delegatesToOutput.add(xxx);
            }
            System.out.println(xx);
            System.out.println(entityNameMap);
            System.out.println(delegatesToOutput);
            if (delegatesToOutput.size() > 0) {
                for (String instanceName : delegatesToOutput) {
                    String typeName = entityNameMap.get(instanceName);
                    ps.println("\t/** " + typeName + " superclass instance */");
                    ps.println("\tprivate " + typeName + " " + instanceName + " = new " + typeName + "Impl();\n");
                }
            }
            for (PropertyDef pp : pd.keySet()) {
                String instanceName = (String)pd.get(pp);
                ps.println("\n\t// From class " + instanceName + "\n\n");
                ps.println(pp.toSettersAndGetters("\t", true, instanceName, false));
            }
        }
    }

    public Map<URI, Set<URI>> getAllSuperclasses(RepositoryConnection conn) {
        HashMap<URI, Set<URI>> map = new HashMap<URI, Set<URI>>();
        for (URI uri : this.directSuperclasses) {
            HashSet<URI> uris = new HashSet<URI>();
            ClassDef.getAllSuperclasses(uri, conn, uris);
            map.put(uri, uris);
        }
        return map;
    }

    private static void getAllSuperclasses(URI uri, RepositoryConnection conn, Set<URI> uris) {
        try {
            Set<URI> superclassesOf = ClassDef.getSuperclasses(uri, conn);
            uris.addAll(superclassesOf);
            for (URI u : superclassesOf) {
                ClassDef.getAllSuperclasses(u, conn, uris);
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (MalformedQueryException e) {
            e.printStackTrace();
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
        }
    }

    private void getFullPropertyList(Map<PropertyDef, String> pd, Map<String, String> instanceNameMap, Map<URI, ClassDef> classes) {
        for (PropertyDef pp : this.properties) {
            pd.put(pp, "this");
        }
        for (URI superclass : this.directSuperclasses) {
            String instanceName = superclass.getLocalName().substring(0, 1).toLowerCase() + superclass.getLocalName().substring(1);
            for (PropertyDef pp : classes.get((Object)superclass).properties) {
                pd.put(pp, instanceName);
            }
            for (URI ancestorURI : this.allSuperclasses.get(superclass)) {
                for (PropertyDef pp : classes.get((Object)ancestorURI).properties) {
                    pd.put(pp, instanceName);
                }
            }
            if (pd.keySet().size() == 0 || instanceNameMap.get(instanceName) != null) continue;
            instanceNameMap.put(instanceName, Generator.getTypeName(superclass));
        }
    }
}

