/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.parser;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.jcip.annotations.ThreadSafe;
import net.sourceforge.jeuclid.ResourceEntityResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@ThreadSafe
public final class Parser {
    private static final int DETECTION_BUFFER_SIZE = 128;
    private static final String BAD_STREAM_SOURCE = "Bad StreamSource: ";
    private static final String CONTENT_XML = "content.xml";
    private static final String CANNOT_HANDLE_SOURCE = "Cannot handle Source: ";
    private static final Log LOGGER = LogFactory.getLog(Parser.class);
    private final Map<Long, Reference<DocumentBuilder>> builders = new ConcurrentHashMap<Long, Reference<DocumentBuilder>>();

    protected Parser() {
    }

    private DocumentBuilder createDocumentBuilder() {
        DocumentBuilder documentBuilder;
        try {
            try {
                documentBuilder = this.tryCreateDocumentBuilder(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.debug((Object)("Unsupported Operation: " + unsupportedOperationException.getMessage()));
                documentBuilder = this.tryCreateDocumentBuilder(false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                LOGGER.debug((Object)("ParserConfigurationException: " + parserConfigurationException.getMessage()));
                documentBuilder = this.tryCreateDocumentBuilder(false);
            }
            documentBuilder.setEntityResolver(new ResourceEntityResolver());
            documentBuilder.setErrorHandler(new LoggerErrorHandler());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn((Object)("Could not create Parser: " + parserConfigurationException.getMessage()));
            assert (false) : "Could not create Parser";
            documentBuilder = null;
        }
        return documentBuilder;
    }

    private DocumentBuilder tryCreateDocumentBuilder(boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        if (bl) {
            documentBuilderFactory.setXIncludeAware(true);
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }

    public static Parser getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static Parser getParser() throws ParserConfigurationException {
        return Parser.getInstance();
    }

    public Document parseStreamSource(StreamSource streamSource) throws SAXException, IOException {
        Document document = null;
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            UnclosableInputStream unclosableInputStream = new UnclosableInputStream(inputStream);
            ((InputStream)unclosableInputStream).mark(128);
            try {
                document = this.parseStreamSourceAsXml(new StreamSource(unclosableInputStream));
                inputStream.close();
            }
            catch (SAXParseException sAXParseException) {
                ((InputStream)unclosableInputStream).reset();
                try {
                    document = this.parseStreamSourceAsOdf(new StreamSource(unclosableInputStream));
                }
                catch (IOException iOException) {
                    throw sAXParseException;
                }
                inputStream.close();
            }
        }
        if (document == null) {
            document = this.parseStreamSourceAsXml(streamSource);
        }
        return document;
    }

    public Document parseStreamSourceAsOdf(StreamSource streamSource) throws IOException, SAXException {
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream == null) {
            throw new IllegalArgumentException(BAD_STREAM_SOURCE + streamSource);
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        Document document = null;
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (CONTENT_XML.equals(zipEntry.getName())) {
                document = this.getDocumentBuilder().parse(zipInputStream);
                zipEntry = null;
                continue;
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return document;
    }

    public Document parseStreamSourceAsXml(StreamSource streamSource) throws SAXException, IOException {
        InputSource inputSource = null;
        String string = streamSource.getSystemId();
        if (string != null) {
            inputSource = new InputSource(string);
        }
        InputStream inputStream = streamSource.getInputStream();
        if (inputSource == null && inputStream != null) {
            inputSource = new InputSource(inputStream);
        }
        Reader reader = streamSource.getReader();
        if (inputSource == null && reader != null) {
            inputSource = new InputSource(reader);
        }
        if (inputSource == null) {
            throw new IllegalArgumentException(BAD_STREAM_SOURCE + streamSource);
        }
        return this.getDocumentBuilder().parse(inputSource);
    }

    public DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder;
        long l = Thread.currentThread().getId();
        Reference<DocumentBuilder> reference = this.builders.get(l);
        if (reference != null && (documentBuilder = reference.get()) != null) {
            return documentBuilder;
        }
        documentBuilder = this.createDocumentBuilder();
        this.builders.put(l, new SoftReference<DocumentBuilder>(documentBuilder));
        return documentBuilder;
    }

    public Node parse(Source source) throws SAXException, IOException {
        Node node;
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            node = this.parseStreamSource(streamSource);
        } else if (source instanceof ImageSource) {
            ImageSource imageSource = (ImageSource)source;
            StreamSource streamSource = new StreamSource(imageSource.getInputStream());
            node = this.parseStreamSource(streamSource);
        } else if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            node = dOMSource.getNode();
        } else {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMResult dOMResult = new DOMResult();
                transformer.transform(source, dOMResult);
                node = dOMResult.getNode();
            }
            catch (TransformerException transformerException) {
                LOGGER.warn((Object)transformerException.getMessage());
                throw new IllegalArgumentException(CANNOT_HANDLE_SOURCE + source, transformerException);
            }
        }
        return node;
    }

    private static final class SingletonHolder {
        private static final Parser INSTANCE = new Parser();

        private SingletonHolder() {
        }
    }

    private static final class UnclosableInputStream
    extends FilterInputStream {
        protected UnclosableInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public void close() throws IOException {
        }
    }

    private static final class LoggerErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException sAXParseException) throws SAXException {
            LOGGER.warn((Object)sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            LOGGER.debug((Object)sAXParseException);
        }
    }
}

