/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.Vector;
import java.util.Arrays;

public class SymmetricMatrix
extends DenseMatrix {
    public SymmetricMatrix(int size) {
        super(size, size);
    }

    public SymmetricMatrix(double[][] values) {
        super(values);
    }

    @Override
    protected void assertInvariant() throws IllegalArgumentException {
        for (int n = 0; n < this.values.length; ++n) {
            if (this.values[n].length == n + 1) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected double[][] makeValues(int rows, int columns) {
        assert (rows == columns);
        double[][] values = new double[rows][];
        for (int n = 0; n < values.length; ++n) {
            values[n] = new double[n + 1];
        }
        return values;
    }

    @Override
    public int columnCount() {
        return this.rowCount();
    }

    @Override
    public double get(int row, int column) {
        return row > column ? this.values[row][column] : this.values[column][row];
    }

    @Override
    public double put(int row, int column, double value) {
        return row > column ? (this.values[row][column] = value) : (this.values[column][row] = value);
    }

    @Override
    public int rowCount() {
        return this.values.length;
    }

    public static DenseMatrix fromSquare(double[][] square) {
        double[][] jagged = new double[square.length][];
        for (int i = 0; i < jagged.length; ++i) {
            assert (square[i].length == square.length);
            jagged[i] = Arrays.copyOf(square[i], i + 1);
        }
        return new SymmetricMatrix(jagged);
    }

    public static DenseMatrix fromJagged(double[][] values) {
        return new SymmetricMatrix(values);
    }

    @Override
    public double[][] unwrap() {
        return this.values;
    }

    @Override
    public double[] rowwiseMean() {
        double[] mean = new double[this.rowCount()];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < i; ++j) {
                int n = i;
                mean[n] = mean[n] + this.values[i][j];
                int n2 = j;
                mean[n2] = mean[n2] + this.values[i][j];
            }
        }
        int n = 0;
        while (n < mean.length) {
            int n3 = n++;
            mean[n3] = mean[n3] / (double)mean.length;
        }
        return mean;
    }

    @Override
    public Vector mult(Vector v) {
        assert (v.size() == this.values.length);
        double[] mult = new double[v.size()];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < i; ++j) {
                int n = i;
                mult[n] = mult[n] + this.values[i][j] * v.get(j);
                int n2 = j;
                mult[n2] = mult[n2] + this.values[i][j] * v.get(i);
            }
        }
        return Vector.wrap(mult);
    }
}

