/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.DenseMatrix;
import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Util;
import ch.akuhn.matrix.Vector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Matrix {
    private static final int MAX_PRINT = 100;

    public double add(int row, int column, double value) {
        return this.put(row, column, this.get(row, column) + value);
    }

    public Iterable<Vector> rows() {
        return this.vecs(true);
    }

    private Iterable<Vector> vecs(final boolean isRow) {
        return new Iterable<Vector>(){

            @Override
            public Iterator<Vector> iterator() {
                return new Iterator<Vector>(){
                    private int count = 0;

                    @Override
                    public boolean hasNext() {
                        return this.count < (isRow ? Matrix.this.rowCount() : Matrix.this.columnCount());
                    }

                    @Override
                    public Vector next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new Vec(this.count++, isRow);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<Vector> columns() {
        return this.vecs(false);
    }

    public abstract int columnCount();

    public double density() {
        return (double)this.used() / (double)this.elementCount();
    }

    public int elementCount() {
        return this.rowCount() * this.columnCount();
    }

    public abstract double get(int var1, int var2);

    public abstract double put(int var1, int var2, double var3);

    public abstract int rowCount();

    public abstract int used();

    public void storeSparseOn(Appendable appendable) throws IOException {
        appendable.append(this.columnCount() + " ");
        appendable.append(this.rowCount() + " ");
        appendable.append(this.used() + "\r");
        for (Vector row : this.rows()) {
            appendable.append(row.used() + "\r");
            for (Vector.Entry each : row.entries()) {
                appendable.append(each.index + " " + each.value + " ");
            }
            appendable.append("\r");
        }
    }

    public void storeSparseOn(String fname) throws IOException {
        FileWriter fw = new FileWriter(new File(fname));
        this.storeSparseOn(fw);
        fw.close();
    }

    public Vector row(int row) {
        return new Vec(row, true);
    }

    public Vector column(int column) {
        return new Vec(column, false);
    }

    public double[][] asArray() {
        double[][] result = new double[this.rowCount()][this.columnCount()];
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[x].length; ++y) {
                result[x][y] = this.get(x, y);
            }
        }
        return result;
    }

    public static int indexOf(Vector vec) {
        return ((Vec)vec).index0;
    }

    public Vector mult(Vector x) {
        assert (x.size() == this.columnCount());
        Vector y = Vector.dense(this.rowCount());
        int i = 0;
        for (Vector row : this.rows()) {
            y.put(i++, row.dot(x));
        }
        return y;
    }

    public Vector transposeMultiply(Vector x) {
        assert (x.size() == this.rowCount());
        Vector y = Vector.dense(this.columnCount());
        int i = 0;
        for (Vector row : this.rows()) {
            row.scaleAndAddTo(x.get(i++), y);
        }
        return y;
    }

    public Vector transposeNonTransposeMultiply(Vector x) {
        return this.transposeMultiply(this.mult(x));
    }

    public static Matrix from(int n, int m, double ... values) {
        assert (n * m == values.length);
        double[][] data = new double[n][];
        for (int i = 0; i < n; ++i) {
            data[i] = Arrays.copyOfRange(values, i * m, (i + 1) * m);
        }
        return new DenseMatrix(data);
    }

    public static Matrix dense(int n, int m) {
        return new DenseMatrix(n, m);
    }

    public boolean isSquare() {
        return this.columnCount() == this.rowCount();
    }

    public double[] asColumnMajorArray() {
        double[] data = new double[this.columnCount() * this.rowCount()];
        int n = this.columnCount();
        int i = 0;
        for (Vector row : this.rows()) {
            for (Vector.Entry each : row.entries()) {
                data[i + each.index * n] = each.value;
            }
            ++i;
        }
        return data;
    }

    public static SparseMatrix sparse(int n, int m) {
        return new SparseMatrix(n, m);
    }

    public double max() {
        return Util.max(this.unwrap(), Double.NaN);
    }

    public double min() {
        return Util.min(this.unwrap(), Double.NaN);
    }

    public double mean() {
        double[][] values = this.unwrap();
        return Util.sum(values) / (double)Util.count(values);
    }

    public double[][] unwrap() {
        throw new IllegalStateException("cannot unwrap instance of " + this.getClass().getSimpleName());
    }

    public double[] rowwiseMean() {
        double[] mean = new double[this.rowCount()];
        int i = 0;
        for (Vector row : this.rows()) {
            mean[i++] = row.mean();
        }
        return mean;
    }

    public int[] getHistogram() {
        return Util.getHistogram(this.unwrap(), 100);
    }

    public Matrix newInstance() {
        return this.newInstance(this.rowCount(), this.columnCount());
    }

    public abstract Matrix newInstance(int var1, int var2);

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.println("NRows = " + this.rowCount());
        writer.println("NCols = " + this.columnCount());
        int maxPrint = Math.min(this.rowCount() * this.columnCount(), 100);
        for (i = 0; i < maxPrint; ++i) {
            int row = i / this.columnCount();
            int col = i - row * this.columnCount();
            writer.printf("%d\t%d\t%2.5f\n", row, col, this.get(row, col));
        }
        if (i < this.rowCount() * this.columnCount() - 1) {
            writer.printf("...", new Object[0]);
        }
        writer.flush();
        return ((Object)sw).toString();
    }

    private class Vec
    extends Vector {
        int index0;
        private boolean isRow;

        Vec(int n, boolean isRow) {
            this.isRow = isRow;
            this.index0 = n;
        }

        @Override
        public int size() {
            return this.isRow ? Matrix.this.columnCount() : Matrix.this.rowCount();
        }

        @Override
        public double put(int index, double value) {
            return this.isRow ? Matrix.this.put(this.index0, index, value) : Matrix.this.put(index, this.index0, value);
        }

        @Override
        public double get(int index) {
            return this.isRow ? Matrix.this.get(this.index0, index) : Matrix.this.get(index, this.index0);
        }

        @Override
        public boolean equals(Vector v, double epsilon) {
            throw new Error("Not yet implemented");
        }

        @Override
        public Vector times(double scalar) {
            throw new Error("Not yet implemented");
        }

        @Override
        public Vector timesEquals(double scalar) {
            throw new Error("Not yet implemented");
        }
    }
}

