/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.App;
import com.salelder.License;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class LicenseDialog
implements ActionListener {
    private App app;
    private License license;

    public LicenseDialog(App a, License l) {
        this.app = a;
        this.license = l;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.license.isActive()) {
            JOptionPane.showMessageDialog(this.app, "This copy of the software has already been activated.", "Active", 1);
            return;
        }
        String key = JOptionPane.showInputDialog(this.app, "Please enter your license key:", "Registration", 3);
        if (key != null) {
            this.license.setLicense(key);
            int status = this.license.activate();
            if (status == License.CONNECTION_ERROR) {
                JOptionPane.showMessageDialog(this.app, "Could not connect to activation server.\nPlease check your Internet connection and try again.", "Connection error", 0);
            } else if (status == License.LICENSE_NOT_RECOGNIZED) {
                JOptionPane.showMessageDialog(this.app, "License not recognized. Please check that you have entered the\nkey exactly as it was provided when you purchased the software.", "License error", 0);
            } else if (status == License.MAX_DEVICES_REGISTERED) {
                JOptionPane.showMessageDialog(this.app, "Maximum devices already registered with this license key.", "License error", 0);
            } else if (status == License.UNEXPECTED_RESPONSE || !this.license.isActive()) {
                JOptionPane.showMessageDialog(this.app, "Activation server returned an unexpected response.\nPlease contact customer support.", "Activation error", 0);
            } else {
                JOptionPane.showMessageDialog(this.app, "You have successfully activated your copy of the software!", "Success", 1);
            }
        }
        this.app.notifyLicenseChanged();
    }
}

