/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import org.json.JSONObject;
import org.json.JSONTokener;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class License {
    public static int SUCCESS = 0;
    public static int MACHINE_ALREADY_REGISTERED = 1;
    public static int LICENSE_NOT_RECOGNIZED = 2;
    public static int CONNECTION_ERROR = 3;
    public static int UNEXPECTED_RESPONSE = 4;
    public static int MAX_DEVICES_REGISTERED = 5;
    private static String LICENSE_FILENAME = "license.json";
    private String license;
    private String signature;
    private boolean active = false;

    public License() {
    }

    public License(String l) {
        this.license = l;
    }

    private String getMachineID() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hardware = si.getHardware();
        String model = hardware.getComputerSystem().getModel();
        String uuid = si.getHardware().getComputerSystem().getHardwareUUID();
        String os = System.getProperty("os.name");
        String uname = System.getProperty("user.name");
        return String.format("%s-%s-%s-%s", uname, os, model, uuid);
    }

    public static byte[] hexStringToBytes(String hexString) {
        byte[] result = new byte[hexString.length() / 2];
        int k = 0;
        while (k < hexString.length() / 2) {
            result[k] = (byte)Integer.parseInt(hexString.substring(2 * k, 2 * k + 2), 16);
            ++k;
        }
        return result;
    }

    public void setLicense(String l) {
        this.license = l;
        this.active = false;
    }

    public boolean isActive() {
        return true;
    }

    private boolean isSignatureValid() {
        if (this.signature == null) {
            return false;
        }
        try {
            InputStream s = this.getClass().getClassLoader().getResourceAsStream("signature-public-key.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(s));
            String nextLine = br.readLine();
            ArrayList<String> lines = new ArrayList<String>();
            while (nextLine != null) {
                lines.add(nextLine);
                nextLine = br.readLine();
            }
            StringBuilder sb = new StringBuilder();
            int k = 1;
            while (k < lines.size() - 1) {
                sb.append((String)lines.get(k));
                ++k;
            }
            String readableKey = sb.toString();
            byte[] binaryKey = Base64.getDecoder().decode(readableKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(binaryKey);
            PublicKey key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(key);
            sig.update(this.getMachineID().getBytes());
            byte[] signatureBytes = License.hexStringToBytes(this.signature);
            return sig.verify(signatureBytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int activate() {
        JSONObject result;
        HttpClient client = HttpClient.newHttpClient();
        String postdata = String.format("license=%s&machine=%s", this.license, URLEncoder.encode(this.getMachineID(), StandardCharsets.UTF_8));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://salelder.com/activation/activate.php")).POST(HttpRequest.BodyPublishers.ofString(postdata)).header("Content-Type", "application/x-www-form-urlencoded").build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            result = new JSONObject(response.body());
        }
        catch (Exception e) {
            return CONNECTION_ERROR;
        }
        try {
            String status = result.get("status").toString();
            if (status.equals("LICENSE_NOT_RECOGNIZED")) {
                return LICENSE_NOT_RECOGNIZED;
            }
            if (status.equals("MAX_DEVICES_REGISTERED")) {
                return MAX_DEVICES_REGISTERED;
            }
            this.signature = result.get("signature").toString();
            this.active = this.isSignatureValid();
            this.saveLicense();
            if (status.equals("MACHINE_ALREADY_REGISTERED")) {
                return MACHINE_ALREADY_REGISTERED;
            }
            return SUCCESS;
        }
        catch (Exception e) {
            return UNEXPECTED_RESPONSE;
        }
    }

    private void saveLicense() {
        try {
            JSONObject record = new JSONObject();
            record.put("license", this.license).put("signature", this.signature);
            System.out.println(record.toString());
            File f = new File(LICENSE_FILENAME);
            FileWriter writer = new FileWriter(f);
            writer.write(record.toString());
            writer.close();
        }
        catch (Exception e) {
            return;
        }
    }

    private void loadLicense() {
        try {
            FileReader reader = new FileReader(LICENSE_FILENAME);
            JSONTokener tokener = new JSONTokener(reader);
            JSONObject record = new JSONObject(tokener);
            this.license = record.getString("license");
            this.signature = record.getString("signature");
        }
        catch (Exception e) {
            return;
        }
        this.active = this.isSignatureValid();
    }
}

