/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.License;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class DemoImage {
    private MBFImage image;
    private String name;

    public DemoImage(String filename, String md5sum, String name) {
        this.name = name;
        URL imgURL = this.getClass().getClassLoader().getResource(filename);
        try {
            InputStream f = this.getClass().getClassLoader().getResourceAsStream(filename);
            byte[] contents = f.readAllBytes();
            f.close();
            byte[] digest = MessageDigest.getInstance("MD5").digest(contents);
            if (!Arrays.equals(digest, License.hexStringToBytes(md5sum))) {
                throw new Exception();
            }
            this.image = ImageUtilities.readMBF((URL)imgURL);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.image = new MBFImage(200, 200);
        }
    }

    public String toString() {
        return this.name;
    }

    public MBFImage getMBFImage() {
        return this.image;
    }
}

