/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.Quad;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ConfigFile {
    private Quad quad;
    private File refFile;
    private float brightness;
    private float contrast;
    private float scale;
    private float panX;
    private float panY;
    private double colorTemp;
    private int videoWidth;
    private int videoHeight;

    public ConfigFile(Quad q, File r, float brightness, float contrast, float scale, float panX, float panY, double temp, int width, int height) {
        this.quad = q;
        this.refFile = r;
        this.brightness = brightness;
        this.contrast = contrast;
        this.scale = scale;
        this.panX = panX;
        this.panY = panY;
        this.colorTemp = temp;
        this.videoWidth = width;
        this.videoHeight = height;
    }

    public ConfigFile(File f) throws IOException {
        this.loadJSON(f);
    }

    public void loadJSON(File f) throws IOException {
        FileReader reader = new FileReader(f);
        JSONTokener tokener = new JSONTokener(reader);
        JSONObject obj = new JSONObject(tokener);
        JSONArray xs = obj.getJSONArray("xs");
        JSONArray ys = obj.getJSONArray("ys");
        this.quad = new Quad();
        int k = 0;
        while (k < 4) {
            this.quad.xs[k] = xs.getInt(k);
            this.quad.ys[k] = ys.getInt(k);
            ++k;
        }
        if (!obj.isNull("refFile")) {
            this.refFile = new File(obj.getString("refFile"));
        }
        this.brightness = obj.getFloat("brightness");
        this.contrast = obj.getFloat("contrast");
        this.scale = obj.getFloat("scale");
        this.panX = obj.getFloat("panX");
        this.panY = obj.getFloat("panY");
        this.colorTemp = obj.getDouble("colorTemp");
        this.videoWidth = obj.getInt("videoWidth");
        this.videoHeight = obj.getInt("videoHeight");
    }

    public void saveJSON(File f) throws IOException {
        JSONObject obj = new JSONObject();
        JSONArray xs = new JSONArray();
        obj.put("version", 1).put("xs", new JSONArray(this.quad.xs)).put("ys", new JSONArray(this.quad.ys)).put("brightness", this.brightness).put("contrast", this.contrast).put("scale", this.scale).put("panX", this.panX).put("panY", this.panY).put("colorTemp", this.colorTemp).put("videoWidth", this.videoWidth).put("videoHeight", this.videoHeight);
        if (this.refFile == null) {
            obj.put("refFile", JSONObject.NULL);
        } else {
            obj.put("refFile", this.refFile.getAbsolutePath());
        }
        FileWriter writer = new FileWriter(f);
        writer.write(obj.toString());
        writer.close();
    }

    public Quad getQuad() {
        return this.quad;
    }

    public File getReference() {
        return this.refFile;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public float getScale() {
        return this.scale;
    }

    public float getPanX() {
        return this.panX;
    }

    public float getPanY() {
        return this.panY;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public double getTemp() {
        return this.colorTemp;
    }
}

