/*
 * Decompiled with CFR 0.152.
 */
package com.salelder;

import com.salelder.ConfigFile;
import com.salelder.FileListener;
import com.salelder.FileUser;
import com.salelder.License;
import com.salelder.OptionsPanel;
import com.salelder.PreviewController;
import com.salelder.PreviewPanel;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class App
extends JFrame
implements FileUser {
    public static String APP_NAME = "Vermeer Live";
    public static String VERSION = "1.0";
    public JFileChooser fileChooser;
    public JMenuBar menubar;
    private PreviewPanel preview;
    private OptionsPanel options;
    private JLabel statusMessage;
    private File activeFile;
    private PreviewController previewController;
    private License license;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem openItem;

    public App() {
        this.setDefaultCloseOperation(3);
        this.setTitle(APP_NAME);
        this.license = new License();
        if (!this.license.isActive()) {
            JOptionPane.showMessageDialog(this, "This is a demo version. Some features are missing or incomplete.\nTo run the full version, please purchase a license key.", "Demo Version", 1);
        }
        this.menubar = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        this.menubar.add(filemenu);
        filemenu.setMnemonic('f');
        JMenuItem newItem = new JMenuItem("New");
        filemenu.add(newItem);
        this.openItem = new JMenuItem("Open");
        filemenu.add(this.openItem);
        filemenu.addSeparator();
        this.saveItem = new JMenuItem("Save");
        filemenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem("Save As");
        filemenu.add(this.saveAsItem);
        int ctrlKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        KeyStroke ctrlN = KeyStroke.getKeyStroke(78, ctrlKey);
        KeyStroke ctrlO = KeyStroke.getKeyStroke(79, ctrlKey);
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, ctrlKey);
        newItem.setAccelerator(ctrlN);
        this.openItem.setAccelerator(ctrlO);
        this.saveItem.setAccelerator(ctrlS);
        FileNameExtensionFilter jsonFilter = new FileNameExtensionFilter("json", "json");
        this.fileChooser = new JFileChooser();
        FileListener openListener = new FileListener(jsonFilter, this.fileChooser, this.menubar, FileListener.OPEN_DIALOG, this);
        FileListener saveListener = new FileListener(jsonFilter, this.fileChooser, this.menubar, FileListener.SAVE_DIALOG, this);
        FileListener saveAsListener = new FileListener(jsonFilter, this.fileChooser, this.menubar, FileListener.SAVE_AS_DIALOG, this);
        this.openItem.addActionListener(openListener);
        this.saveItem.addActionListener(saveListener);
        this.saveAsItem.addActionListener(saveAsListener);
        JMenu viewmenu = new JMenu("View");
        this.menubar.add(viewmenu);
        viewmenu.setMnemonic('v');
        JMenuItem toggleImageItem = new JMenuItem("Switch image");
        viewmenu.add(toggleImageItem);
        toggleImageItem.setAccelerator(KeyStroke.getKeyStroke('q'));
        JMenu helpmenu = new JMenu("Help");
        this.menubar.add(helpmenu);
        helpmenu.setMnemonic('h');
        helpmenu.addSeparator();
        JMenuItem aboutItem = new JMenuItem("About");
        helpmenu.add(aboutItem);
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(App.this, String.format("%s\nVersion %s\nCopyright \u00a9 2021 Sal Elder\nReleased under an MIT license.", APP_NAME, VERSION));
            }
        });
        JPanel statusPanel = new JPanel();
        this.statusMessage = new JLabel("");
        statusPanel.add(this.statusMessage);
        this.preview = new PreviewPanel(this);
        this.options = new OptionsPanel(this.preview, this.license);
        toggleImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                App.this.options.toggleOpacity();
            }
        });
        this.notifyLicenseChanged();
        this.setJMenuBar(this.menubar);
        JSplitPane split = new JSplitPane(1, this.preview, this.options);
        this.add((Component)split, "Center");
        this.add((Component)statusPanel, "Last");
        this.pack();
        this.setVisible(true);
    }

    public void setStatus(String message) {
        this.statusMessage.setText(message);
    }

    public void notifyLicenseChanged() {
        boolean active = this.license.isActive();
        this.saveItem.setEnabled(active);
        this.saveAsItem.setEnabled(active);
        this.openItem.setEnabled(active);
    }

    public static void main(String[] args) throws IOException {
        new App();
    }

    @Override
    public boolean hasActiveFile() {
        return this.activeFile != null;
    }

    @Override
    public void openFile(File f) {
        try {
            ConfigFile config = new ConfigFile(f);
            this.preview.quad = config.getQuad();
            this.preview.setReference(config.getReference());
            this.options.setParams(config.getBrightness(), config.getContrast(), config.getScale(), config.getPanX(), config.getPanY(), config.getTemp(), config.getVideoWidth(), config.getVideoHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setStatus("Error: couldn't load settings.");
        }
    }

    @Override
    public void saveFile(File f) {
        ConfigFile config = new ConfigFile(this.preview.quad, this.preview.getReferenceFile(), this.preview.brightness, this.preview.contrast, this.preview.scale, this.preview.panX, this.preview.panY, this.preview.colorTemp, this.preview.getVideoWidth(), this.preview.getVideoHeight());
        try {
            config.saveJSON(f);
            this.activeFile = f;
            this.setStatus("Saved settings.");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setStatus("Error: couldn't save settings.");
        }
    }

    @Override
    public void saveFile() {
        this.saveFile(this.activeFile);
    }
}

