/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.readytogopack;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfStream;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBSMARDFStreamTestGenerator
extends RdfStream
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(LBSMARDFStreamTestGenerator.class);
    private int c = 1;
    private int ct = 1;
    private boolean keepRunning = false;

    public LBSMARDFStreamTestGenerator(String iri) {
        super(iri);
    }

    public void pleaseStop() {
        this.keepRunning = false;
    }

    @Override
    public void run() {
        this.keepRunning = true;
        while (this.keepRunning) {
            RdfQuadruple q = new RdfQuadruple("http://myexample.org/user" + this.c, "http://myexample.org/likes", "http://myexample.org/O" + this.c, System.nanoTime());
            this.put(q);
            ++this.ct;
            double n = Math.random() * 5.0;
            int i = 0;
            while ((double)i < n) {
                RdfQuadruple q1 = new RdfQuadruple("http://myexample.org/user" + this.c + i, "http://myexample.org/likes", "http://myexample.org/O" + this.c, System.nanoTime());
                this.put(q1);
                ++this.ct;
                ++i;
            }
            if (this.c % 10 == 0) {
                this.logger.info(String.valueOf(this.ct) + " triples streamed so far");
            }
            ++this.c;
        }
    }

    public static String dumpRelatedStaticKnowledge(int maxUser) {
        Model m = ModelFactory.createDefaultModel();
        int j = 0;
        while (j < maxUser) {
            int i = 0;
            while (i < 5) {
                m.add((Resource)new ResourceImpl("http://myexample.org/user" + j + i), (Property)new PropertyImpl("http://myexample.org/follows"), new ResourceImpl("http://myexample.org/user" + j));
                ++i;
            }
            ++j;
        }
        StringWriter sw = new StringWriter();
        m.write(sw, "RDF/XML");
        return sw.toString();
    }

    public static void main(String[] args) {
        System.out.println(LBSMARDFStreamTestGenerator.dumpRelatedStaticKnowledge(10));
    }
}

