/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.parser;

import eu.larkc.csparql.parser.CSparqlLexer;
import eu.larkc.csparql.parser.CSparqlParser;
import eu.larkc.csparql.parser.ClassFinder;
import eu.larkc.csparql.parser.EplProducer1_0;
import eu.larkc.csparql.parser.PostProcessingException;
import eu.larkc.csparql.parser.SparqlLexer;
import eu.larkc.csparql.parser.SparqlParser;
import eu.larkc.csparql.parser.SparqlProducer1_0;
import eu.larkc.csparql.parser.Translator;
import eu.larkc.csparql.parser.TreeBox;
import eu.larkc.csparql.parser.TreeCheckerInterface;
import eu.larkc.csparql.streams.formats.CSparqlQuery;
import eu.larkc.csparql.streams.formats.CSparqlQueryImpl;
import eu.larkc.csparql.streams.formats.TranslationException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.ParseTreeBuilder;
import org.antlr.runtime.tree.ParseTree;

public final class CSparqlTranslator
extends Translator {
    private static String language = "CSparql";

    private static TreeBox parse(String query) throws RecognitionException, PostProcessingException {
        if (language.contentEquals("CSparql")) {
            query = CSparqlTranslator.preprocessQuery(query);
            ANTLRStringStream input = new ANTLRStringStream(query);
            CSparqlLexer lexer = new CSparqlLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            ParseTreeBuilder builder = new ParseTreeBuilder("queryWithReg");
            CSparqlParser parser = new CSparqlParser((TokenStream)tokens, builder);
            CSparqlParser.queryWithReg_return result = parser.queryWithReg();
            ParseTree debug = builder.getTree();
            TreeBox tb = TreeBox.create(debug);
            TreeBox.decorate(tb);
            CSparqlTranslator.postProcessing(tb);
            return tb;
        }
        query = CSparqlTranslator.preprocessQuery(query);
        ANTLRStringStream input = new ANTLRStringStream(query);
        SparqlLexer lexer = new SparqlLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ParseTreeBuilder builder = new ParseTreeBuilder("query");
        SparqlParser parser = new SparqlParser((TokenStream)tokens, builder);
        SparqlParser.query_return result = parser.query();
        ParseTree debug = builder.getTree();
        TreeBox tb = TreeBox.create(debug);
        TreeBox.decorate(tb);
        CSparqlTranslator.postProcessing(tb);
        return tb;
    }

    private static String preprocessQuery(String query) {
        char literal;
        int n;
        int n2;
        char[] cArray;
        char[] c;
        Pattern compiledRegex1 = Pattern.compile("\\\\u([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])", 8);
        Pattern compiledRegex2 = Pattern.compile("\\\\U([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])([\\da-fA-F])", 8);
        String unicode = new String();
        StringBuffer queryOk = new StringBuffer();
        Matcher regexMatcher = compiledRegex1.matcher(query);
        while (regexMatcher.find()) {
            unicode = "0x" + regexMatcher.group(0).substring(2);
            try {
                cArray = c = Character.toChars(Integer.decode(unicode));
                n2 = c.length;
                n = 0;
                while (n < n2) {
                    literal = cArray[n];
                    unicode = "" + literal;
                    ++n;
                }
                regexMatcher.appendReplacement(queryOk, unicode);
            }
            catch (NumberFormatException nfe) {
                nfe.toString();
            }
        }
        regexMatcher.appendTail(queryOk);
        query = queryOk.toString();
        queryOk = new StringBuffer();
        regexMatcher = compiledRegex2.matcher(query);
        while (regexMatcher.find()) {
            unicode = "0x" + regexMatcher.group(0).substring(2);
            cArray = c = Character.toChars(Integer.decode(unicode));
            n2 = c.length;
            n = 0;
            while (n < n2) {
                literal = cArray[n];
                unicode = "" + literal;
                ++n;
            }
            regexMatcher.appendReplacement(queryOk, unicode);
        }
        regexMatcher.appendTail(queryOk);
        return queryOk.toString();
    }

    private static void postProcessing(TreeBox tbx) throws PostProcessingException {
        List<Class> classList = ClassFinder.find(CSparqlTranslator.class.getPackage().getName(), "TreeCheckerInterface");
        for (Class c : classList) {
            try {
                TreeCheckerInterface i = (TreeCheckerInterface)c.newInstance();
                i.treeCheck(tbx);
            }
            catch (InstantiationException ie) {
                ie.toString();
            }
            catch (IllegalAccessException iae) {
                iae.toString();
            }
        }
    }

    @Override
    public CSparqlQuery translate(String queryCommand) throws TranslationException {
        try {
            TreeBox tb = CSparqlTranslator.parse(queryCommand);
            EplProducer1_0 ep = new EplProducer1_0(this.getEngine());
            SparqlProducer1_0 sp = new SparqlProducer1_0();
            Set<String> epls = ep.produceEpl(tb);
            String spq = sp.produceSparql(tb);
            CSparqlQueryImpl csq = new CSparqlQueryImpl(epls.toArray()[0].toString(), spq, queryCommand);
            csq.setTreeBox(tb);
            return csq;
        }
        catch (RecognitionException e) {
            throw new TranslationException("Incorrect Syntax near \"" + e.token.getText() + "\"");
        }
        catch (PostProcessingException e) {
            throw new TranslationException(e.getMessage());
        }
    }
}

