/*
 * Decompiled with CFR 0.152.
 */
package eu.larkc.csparql.engine;

import eu.larkc.csparql.cep.api.CepEngine;
import eu.larkc.csparql.cep.api.RdfQuadruple;
import eu.larkc.csparql.cep.api.RdfSnapshot;
import eu.larkc.csparql.cep.api.RdfStream;
import eu.larkc.csparql.common.RDFTable;
import eu.larkc.csparql.common.streams.format.GenericObservable;
import eu.larkc.csparql.common.streams.format.GenericObserver;
import eu.larkc.csparql.core.Configuration;
import eu.larkc.csparql.engine.CsparqlEngine;
import eu.larkc.csparql.engine.CsparqlQueryResultProxy;
import eu.larkc.csparql.engine.Reasoner;
import eu.larkc.csparql.parser.StreamInfo;
import eu.larkc.csparql.parser.Translator;
import eu.larkc.csparql.sparql.api.SparqlEngine;
import eu.larkc.csparql.streams.formats.CSparqlQuery;
import eu.larkc.csparql.streams.formats.TranslationException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsparqlEngineImpl
implements GenericObserver<List<RdfQuadruple>>,
CsparqlEngine {
    private Configuration configuration = null;
    private Collection<CSparqlQuery> queries = null;
    private Map<String, RdfStream> streams = null;
    private Map<CSparqlQuery, RdfSnapshot> snapshots = null;
    private Map<CSparqlQuery, CsparqlQueryResultProxy> results = null;
    private CepEngine cepEngine = null;
    private SparqlEngine sparqlEngine = null;
    private Reasoner reasoner = null;
    protected final Logger logger = LoggerFactory.getLogger(CsparqlEngineImpl.class);

    @Override
    public Collection<CSparqlQuery> getAllQueries() {
        return this.queries;
    }

    @Override
    public void initialize() {
        this.configuration = new Configuration();
        this.queries = new ArrayList<CSparqlQuery>();
        this.streams = new HashMap<String, RdfStream>();
        this.snapshots = new HashMap<CSparqlQuery, RdfSnapshot>();
        this.results = new HashMap<CSparqlQuery, CsparqlQueryResultProxy>();
        this.sparqlEngine = this.configuration.createSparqlEngine();
        this.cepEngine = this.configuration.createCepEngine();
        this.reasoner = this.configuration.createReasoner();
        this.cepEngine.initialize();
        this.sparqlEngine.initialize();
    }

    private CSparqlQuery getQueryByID(String id) {
        for (CSparqlQuery q : this.queries) {
            if (!q.getId().equalsIgnoreCase(id)) continue;
            return q;
        }
        return null;
    }

    @Override
    public RdfStream registerStream(RdfStream s) {
        this.streams.put(s.getIRI(), s);
        this.cepEngine.registerStream(s);
        return s;
    }

    public void unregisterDataProvider(RdfStream provider) {
        this.streams.remove(provider);
    }

    private void unregisterAllQueries() {
        for (CSparqlQuery q : this.queries) {
            this.unregisterQuery(q.getId());
        }
    }

    @Override
    public void startQuery(String id) {
        this.cepEngine.startQuery(id);
    }

    @Override
    public void stopQuery(String id) {
        this.cepEngine.stopQuery(id);
    }

    private void unregisterQuery(CSparqlQuery q) {
        this.stopQuery(q.getId());
        if (q != null) {
            this.queries.remove(q);
        }
    }

    @Override
    public void unregisterQuery(String id) {
        CSparqlQuery q = this.getQueryByID(id);
        this.unregisterQuery(q);
    }

    @Override
    public void unregisterStream(String iri) {
        RdfStream r = this.getStreamByIri(iri);
        if (r == null) {
            return;
        }
        this.streams.remove(iri);
    }

    @Override
    public CsparqlQueryResultProxy registerQuery(String command) throws ParseException {
        Translator t = Configuration.getCurrentConfiguration().createTranslator(this);
        CSparqlQuery query = null;
        try {
            query = t.translate(command);
        }
        catch (TranslationException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        RdfSnapshot s = this.cepEngine.registerQuery(query.getCepQuery().getQueryCommand(), query.getId());
        CsparqlQueryResultProxy result = new CsparqlQueryResultProxy(query.getId());
        this.queries.add(query);
        this.snapshots.put(query, s);
        this.results.put(query, result);
        s.addObserver(this);
        return result;
    }

    @Override
    public void destroy() {
        this.unregisterAllQueries();
        this.cepEngine.destroy();
    }

    @Override
    public void update(GenericObservable<List<RdfQuadruple>> observed, List<RdfQuadruple> quads) {
        long starttime = System.nanoTime();
        RdfSnapshot r = (RdfSnapshot)observed;
        CSparqlQuery csparqlquery = this.getQueryByID(r.getId());
        RdfSnapshot augmentedSnapshot = this.reasoner.augment(r);
        this.snapshots.put(csparqlquery, augmentedSnapshot);
        this.sparqlEngine.clean();
        long count = 0L;
        for (RdfQuadruple q : quads) {
            if (!this.isStreamUsedInQuery(csparqlquery, q.getStreamName())) continue;
            this.sparqlEngine.addStatement(q.getSubject(), q.getPredicate(), q.getObject(), q.getTimestamp());
            ++count;
        }
        if (count == 0L) {
            return;
        }
        RDFTable result = this.sparqlEngine.evaluateQuery(csparqlquery.getSparqlQuery());
        this.timestamp(result, csparqlquery);
        this.logger.info("results obtained in " + (System.nanoTime() - starttime) + " nanoseconds");
        this.notifySubscribers(csparqlquery, result);
    }

    private void timestamp(RDFTable r, CSparqlQuery q) {
        if (q.getQueryCommand().toLowerCase().contains("register stream")) {
            r.add("timestamp", "0");
        }
    }

    private boolean isStreamUsedInQuery(CSparqlQuery csparqlquery, String streamName) {
        for (StreamInfo si : csparqlquery.getStreams()) {
            if (!si.getIri().equalsIgnoreCase(streamName)) continue;
            return true;
        }
        return false;
    }

    private void notifySubscribers(CSparqlQuery csparqlquery, RDFTable result) {
        CsparqlQueryResultProxy res = this.results.get(csparqlquery);
        res.notifyObservers(result);
    }

    @Override
    public RdfStream getStreamByIri(String iri) {
        if (this.streams.containsKey(iri)) {
            return this.streams.get(iri);
        }
        return null;
    }
}

