/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneFieldUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(CloneFieldUpdateProcessorFactory.class);
    public static final String SOURCE_PARAM = "source";
    public static final String DEST_PARAM = "dest";
    private FieldMutatingUpdateProcessorFactory.SelectorParams srcInclusions = new FieldMutatingUpdateProcessorFactory.SelectorParams();
    private Collection<FieldMutatingUpdateProcessorFactory.SelectorParams> srcExclusions = new ArrayList<FieldMutatingUpdateProcessorFactory.SelectorParams>();
    private FieldMutatingUpdateProcessor.FieldNameSelector srcSelector = null;
    private String dest = null;

    protected final FieldMutatingUpdateProcessor.FieldNameSelector getSourceSelector() {
        if (null != this.srcSelector) {
            return this.srcSelector;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "selector was never initialized,  inform(SolrCore) never called???");
    }

    @Override
    public void init(NamedList args) {
        Object d = args.remove(DEST_PARAM);
        if (null == d) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' must be specified");
        }
        if (!(d instanceof CharSequence)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'dest' must be a string (ie: 'str')");
        }
        this.dest = d.toString();
        List sources = args.getAll(SOURCE_PARAM);
        if (0 == sources.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' must be specified");
        }
        if (1 == sources.size() && sources.get(0) instanceof NamedList) {
            NamedList selectorConfig = (NamedList)args.remove(SOURCE_PARAM);
            this.srcInclusions = CloneFieldUpdateProcessorFactory.parseSelectorParams(selectorConfig);
            List excList = selectorConfig.getAll("exclude");
            for (Object excObj : excList) {
                if (null == excObj) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' child 'exclude' can not be null");
                }
                if (!(excObj instanceof NamedList)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' child 'exclude' must be <lst/>");
                }
                NamedList exc = (NamedList)excObj;
                this.srcExclusions.add(CloneFieldUpdateProcessorFactory.parseSelectorParams(exc));
                if (0 < exc.size()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' has unexpected 'exclude' sub-param(s): '" + selectorConfig.getName(0) + "'");
                }
                selectorConfig.remove("exclude");
            }
            if (0 < selectorConfig.size()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Init param 'source' contains unexpected child param(s): '" + selectorConfig.getName(0) + "'");
            }
        } else {
            this.srcInclusions.fieldName = new HashSet<String>(FieldMutatingUpdateProcessorFactory.oneOrMany(args, SOURCE_PARAM));
        }
        if (0 < args.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
        super.init(args);
    }

    @Override
    public void inform(SolrCore core) {
        this.srcSelector = FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, this.srcInclusions, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS);
        for (FieldMutatingUpdateProcessorFactory.SelectorParams exc : this.srcExclusions) {
            this.srcSelector = FieldMutatingUpdateProcessor.wrap(this.srcSelector, FieldMutatingUpdateProcessor.createFieldNameSelector(core.getResourceLoader(), core, exc, FieldMutatingUpdateProcessor.SELECT_NO_FIELDS));
        }
    }

    @Override
    public final UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                SolrInputDocument doc = cmd.getSolrInputDocument();
                SolrInputField destField = doc.containsKey((Object)CloneFieldUpdateProcessorFactory.this.dest) ? doc.getField(CloneFieldUpdateProcessorFactory.this.dest) : new SolrInputField(CloneFieldUpdateProcessorFactory.this.dest);
                boolean modified = false;
                for (String fname : doc.getFieldNames()) {
                    if (!CloneFieldUpdateProcessorFactory.this.srcSelector.shouldMutate(fname)) continue;
                    for (Object val : doc.getFieldValues(fname)) {
                        destField.addValue(val, 1.0f);
                    }
                    modified = true;
                }
                if (modified) {
                    doc.put(CloneFieldUpdateProcessorFactory.this.dest, destField);
                }
                super.processAdd(cmd);
            }
        };
    }

    private static FieldMutatingUpdateProcessorFactory.SelectorParams parseSelectorParams(NamedList args) {
        return FieldMutatingUpdateProcessorFactory.parseSelectorParams(args);
    }
}

