/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public abstract class AbstractDefaultValueUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    protected String fieldName = null;

    @Override
    public void init(NamedList args) {
        Object obj = args.remove("fieldName");
        if (null == obj && null == this.fieldName) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'fieldName' init param must be specified and non-null");
        }
        this.fieldName = obj.toString();
        if (0 < args.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
        super.init(args);
    }

    protected static abstract class DefaultValueUpdateProcessor
    extends UpdateRequestProcessor {
        final String fieldName;

        public DefaultValueUpdateProcessor(String fieldName, UpdateRequestProcessor next) {
            super(next);
            this.fieldName = fieldName;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            SolrInputDocument doc = cmd.getSolrInputDocument();
            if (!doc.containsKey((Object)this.fieldName)) {
                doc.addField(this.fieldName, this.getDefaultValue());
            }
            super.processAdd(cmd);
        }

        public abstract Object getDefaultValue();
    }
}

