/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.solr.store.blockcache.BufferStore;

public abstract class ReusedBufferedIndexOutput
extends IndexOutput {
    public static final int BUFFER_SIZE = 1024;
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;
    private long fileLength = 0L;

    public ReusedBufferedIndexOutput() {
        this(1024);
    }

    public ReusedBufferedIndexOutput(int bufferSize) {
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
        this.buffer = BufferStore.takeBuffer(this.bufferSize);
    }

    protected long getBufferStart() {
        return this.bufferStart;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0 (got " + bufferSize + ")");
        }
    }

    private void flushBufferToCache() throws IOException {
        this.writeInternal(this.buffer, 0, this.bufferLength);
        this.bufferStart += (long)this.bufferLength;
        this.bufferLength = 0;
        this.bufferPosition = 0;
    }

    protected abstract void flushInternal() throws IOException;

    public void flush() throws IOException {
        this.flushBufferToCache();
        this.flushInternal();
    }

    protected abstract void closeInternal() throws IOException;

    public void close() throws IOException {
        this.flushBufferToCache();
        this.closeInternal();
        BufferStore.putBuffer(this.buffer);
        this.buffer = null;
    }

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public void seek(long pos) throws IOException {
        if (pos > this.fileLength) {
            this.fileLength = pos;
        }
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.flushBufferToCache();
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    public long length() throws IOException {
        return this.fileLength;
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition >= this.bufferSize) {
            this.flushBufferToCache();
        }
        if (this.getFilePointer() >= this.fileLength) {
            ++this.fileLength;
        }
        this.buffer[this.bufferPosition++] = b;
        if (this.bufferPosition > this.bufferLength) {
            this.bufferLength = this.bufferPosition;
        }
    }

    protected abstract void writeInternal(byte[] var1, int var2, int var3) throws IOException;

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        if (this.getFilePointer() + (long)length > this.fileLength) {
            this.fileLength = this.getFilePointer() + (long)length;
        }
        if (length <= this.bufferSize - this.bufferPosition) {
            if (length > 0) {
                System.arraycopy(b, offset, this.buffer, this.bufferPosition, length);
            }
            this.bufferPosition += length;
            if (this.bufferPosition > this.bufferLength) {
                this.bufferLength = this.bufferPosition;
            }
        } else {
            int available = this.bufferSize - this.bufferPosition;
            if (available > 0) {
                System.arraycopy(b, offset, this.buffer, this.bufferPosition, available);
                offset += available;
                length -= available;
                this.bufferPosition = this.bufferSize;
                this.bufferLength = this.bufferSize;
            }
            this.flushBufferToCache();
            if (length < this.bufferSize) {
                System.arraycopy(b, offset, this.buffer, 0, length);
                this.bufferPosition = length;
                this.bufferLength = length;
            } else {
                this.writeInternal(b, offset, length);
                this.bufferStart += (long)length;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

