/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;

public class Metrics
implements Updater {
    public AtomicLong blockCacheHit = new AtomicLong(0L);
    public AtomicLong blockCacheMiss = new AtomicLong(0L);
    public AtomicLong blockCacheEviction = new AtomicLong(0L);
    public AtomicLong blockCacheSize = new AtomicLong(0L);
    public AtomicLong rowReads = new AtomicLong(0L);
    public AtomicLong rowWrites = new AtomicLong(0L);
    public AtomicLong recordReads = new AtomicLong(0L);
    public AtomicLong recordWrites = new AtomicLong(0L);
    public AtomicLong queriesExternal = new AtomicLong(0L);
    public AtomicLong queriesInternal = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocate1024 = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocate8192 = new AtomicLong(0L);
    public AtomicLong shardBuffercacheAllocateOther = new AtomicLong(0L);
    public AtomicLong shardBuffercacheLost = new AtomicLong(0L);
    public Map<String, MethodCall> methodCalls = new ConcurrentHashMap<String, MethodCall>();
    public AtomicLong tableCount = new AtomicLong(0L);
    public AtomicLong rowCount = new AtomicLong(0L);
    public AtomicLong recordCount = new AtomicLong(0L);
    public AtomicLong indexCount = new AtomicLong(0L);
    public AtomicLong indexMemoryUsage = new AtomicLong(0L);
    public AtomicLong segmentCount = new AtomicLong(0L);
    private MetricsRecord metricsRecord;
    private long previous = System.nanoTime();

    public static void main(String[] args) throws InterruptedException {
        Configuration conf = new Configuration();
        Metrics metrics = new Metrics(conf);
        MethodCall methodCall = new MethodCall();
        metrics.methodCalls.put("test", methodCall);
        for (int i = 0; i < 100; ++i) {
            metrics.blockCacheHit.incrementAndGet();
            metrics.blockCacheMiss.incrementAndGet();
            methodCall.invokes.incrementAndGet();
            methodCall.times.addAndGet(56000000L);
            Thread.sleep(500L);
        }
    }

    public Metrics(Configuration conf) {
        JvmMetrics.init((String)"blockcache", (String)Long.toString(System.currentTimeMillis()));
        MetricsContext metricsContext = MetricsUtil.getContext((String)"blockcache");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)metricsContext, (String)"metrics");
        metricsContext.registerUpdater((Updater)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        Metrics metrics = this;
        synchronized (metrics) {
            long now = System.nanoTime();
            float seconds = (float)(now - this.previous) / 1.0E9f;
            this.metricsRecord.setMetric("blockcache.hit", this.getPerSecond(this.blockCacheHit.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("blockcache.miss", this.getPerSecond(this.blockCacheMiss.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("blockcache.eviction", this.getPerSecond(this.blockCacheEviction.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("blockcache.size", this.blockCacheSize.get());
            this.metricsRecord.setMetric("row.reads", this.getPerSecond(this.rowReads.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("row.writes", this.getPerSecond(this.rowWrites.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("record.reads", this.getPerSecond(this.recordReads.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("record.writes", this.getPerSecond(this.recordWrites.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("query.external", this.getPerSecond(this.queriesExternal.getAndSet(0L), seconds));
            this.metricsRecord.setMetric("query.internal", this.getPerSecond(this.queriesInternal.getAndSet(0L), seconds));
            for (Map.Entry<String, MethodCall> entry : this.methodCalls.entrySet()) {
                String key = entry.getKey();
                MethodCall value = entry.getValue();
                long invokes = value.invokes.getAndSet(0L);
                long times = value.times.getAndSet(0L);
                float avgTimes = (float)times / (float)invokes / 1.0E9f;
                this.metricsRecord.setMetric("methodcalls." + key + ".count", this.getPerSecond(invokes, seconds));
                this.metricsRecord.setMetric("methodcalls." + key + ".time", avgTimes);
            }
            this.metricsRecord.setMetric("tables", this.tableCount.get());
            this.metricsRecord.setMetric("rows", this.rowCount.get());
            this.metricsRecord.setMetric("records", this.recordCount.get());
            this.metricsRecord.setMetric("index.count", this.indexCount.get());
            this.metricsRecord.setMetric("index.memoryusage", this.indexMemoryUsage.get());
            this.metricsRecord.setMetric("index.segments", this.segmentCount.get());
            this.previous = now;
        }
        this.metricsRecord.update();
    }

    private float getPerSecond(long value, float seconds) {
        return (float)value / seconds;
    }

    public static class MethodCall {
        public AtomicLong invokes = new AtomicLong();
        public AtomicLong times = new AtomicLong();
    }
}

