/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.search.ReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaXmlWriter
extends TextResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(SchemaXmlWriter.class);
    private static final char[] XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".toCharArray();
    private static final char[] MANAGED_SCHEMA_DO_NOT_EDIT_WARNING = "<!-- Solr managed schema - automatically generated - DO NOT EDIT -->".toCharArray();
    private boolean emitManagedSchemaDoNotEditWarning = false;

    public void setEmitManagedSchemaDoNotEditWarning(boolean emitManagedSchemaDoNotEditWarning) {
        this.emitManagedSchemaDoNotEditWarning = emitManagedSchemaDoNotEditWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SchemaXmlWriter schemaXmlWriter = null;
        try {
            schemaXmlWriter = new SchemaXmlWriter(writer, req, rsp);
            schemaXmlWriter.writeResponse();
        }
        finally {
            if (null != schemaXmlWriter) {
                schemaXmlWriter.close();
            }
        }
    }

    public SchemaXmlWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
    }

    public void writeResponse() throws IOException {
        this.writer.write(XML_DECLARATION);
        if (this.emitManagedSchemaDoNotEditWarning) {
            if (this.doIndent) {
                this.writer.write('\n');
            }
            this.writer.write(MANAGED_SCHEMA_DO_NOT_EDIT_WARNING);
        }
        SimpleOrderedMap schemaProperties = (SimpleOrderedMap)this.rsp.getValues().get("schema");
        this.openStartTag("schema");
        this.writeAttr("name", schemaProperties.get("name").toString());
        this.writeAttr("version", schemaProperties.get("version").toString());
        this.closeStartTag(false);
        this.incLevel();
        for (int schemaPropNum = 0; schemaPropNum < schemaProperties.size(); ++schemaPropNum) {
            String schemaPropName = schemaProperties.getName(schemaPropNum);
            if (schemaPropName.equals("name") || schemaPropName.equals("version")) continue;
            if (schemaPropName.equals("uniqueKey")) {
                this.openStartTag("uniqueKey");
                this.closeStartTag(false);
                this.writer.write(schemaProperties.getVal(schemaPropNum).toString());
                this.endTag("uniqueKey", false);
                continue;
            }
            if (schemaPropName.equals("defaultSearchField")) {
                this.openStartTag("defaultSearchField");
                this.closeStartTag(false);
                this.writer.write(schemaProperties.getVal(schemaPropNum).toString());
                this.endTag("defaultSearchField", false);
                continue;
            }
            if (schemaPropName.equals("solrQueryParser")) {
                this.openStartTag("solrQueryParser");
                SimpleOrderedMap solrQueryParserProperties = (SimpleOrderedMap)schemaProperties.getVal(schemaPropNum);
                this.writeAttr("defaultOperator", solrQueryParserProperties.get("defaultOperator").toString());
                this.closeStartTag(true);
                continue;
            }
            if (schemaPropName.equals("similarity")) {
                this.writeSimilarity((SimpleOrderedMap<Object>)((SimpleOrderedMap)schemaProperties.getVal(schemaPropNum)));
                continue;
            }
            if (schemaPropName.equals("fieldTypes")) {
                this.writeFieldTypes((List)schemaProperties.getVal(schemaPropNum));
                continue;
            }
            if (schemaPropName.equals("fields")) {
                this.openStartTag("fields");
                this.closeStartTag(false);
                this.incLevel();
                List fieldPropertiesList = (List)schemaProperties.getVal(schemaPropNum);
                for (SimpleOrderedMap fieldProperties : fieldPropertiesList) {
                    this.openStartTag("field");
                    for (int fieldPropNum = 0; fieldPropNum < fieldProperties.size(); ++fieldPropNum) {
                        this.writeAttr(fieldProperties.getName(fieldPropNum), fieldProperties.getVal(fieldPropNum).toString());
                    }
                    this.closeStartTag(true);
                }
                continue;
            }
            if (schemaPropName.equals("dynamicFields")) {
                List dynamicFieldPropertiesList = (List)schemaProperties.getVal(schemaPropNum);
                for (SimpleOrderedMap dynamicFieldProperties : dynamicFieldPropertiesList) {
                    this.openStartTag("dynamicField");
                    for (int dynamicFieldPropNum = 0; dynamicFieldPropNum < dynamicFieldProperties.size(); ++dynamicFieldPropNum) {
                        this.writeAttr(dynamicFieldProperties.getName(dynamicFieldPropNum), dynamicFieldProperties.getVal(dynamicFieldPropNum).toString());
                    }
                    this.closeStartTag(true);
                }
                this.decLevel();
                this.endTag("fields");
                continue;
            }
            if (schemaPropName.equals("copyFields")) {
                List copyFieldPropertiesList = (List)schemaProperties.getVal(schemaPropNum);
                for (SimpleOrderedMap copyFieldProperties : copyFieldPropertiesList) {
                    this.openStartTag("copyField");
                    for (int copyFieldPropNum = 0; copyFieldPropNum < copyFieldProperties.size(); ++copyFieldPropNum) {
                        this.writeAttr(copyFieldProperties.getName(copyFieldPropNum), copyFieldProperties.getVal(copyFieldPropNum).toString());
                    }
                    this.closeStartTag(true);
                }
                continue;
            }
            log.warn("Unknown schema component '" + schemaPropName + "'");
        }
        this.decLevel();
        this.endTag("schema");
    }

    private void writeFieldTypes(List<SimpleOrderedMap<Object>> fieldTypePropertiesList) throws IOException {
        this.openStartTag("types");
        this.closeStartTag(false);
        this.incLevel();
        for (SimpleOrderedMap<Object> fieldTypeProperties : fieldTypePropertiesList) {
            boolean isEmptyTag;
            SimpleOrderedMap analyzerProperties = null;
            SimpleOrderedMap indexAnalyzerProperties = null;
            SimpleOrderedMap queryAnalyzerProperties = null;
            SimpleOrderedMap multiTermAnalyzerProperties = null;
            SimpleOrderedMap perFieldSimilarityProperties = null;
            this.openStartTag("fieldType");
            for (int fieldTypePropNum = 0; fieldTypePropNum < fieldTypeProperties.size(); ++fieldTypePropNum) {
                String fieldTypePropName = fieldTypeProperties.getName(fieldTypePropNum);
                if (fieldTypePropName.equals("analyzer")) {
                    analyzerProperties = (SimpleOrderedMap)fieldTypeProperties.getVal(fieldTypePropNum);
                    continue;
                }
                if (fieldTypePropName.equals("indexAnalyzer")) {
                    indexAnalyzerProperties = (SimpleOrderedMap)fieldTypeProperties.getVal(fieldTypePropNum);
                    continue;
                }
                if (fieldTypePropName.equals("queryAnalyzer")) {
                    queryAnalyzerProperties = (SimpleOrderedMap)fieldTypeProperties.getVal(fieldTypePropNum);
                    continue;
                }
                if (fieldTypePropName.equals("multiTermAnalyzer")) {
                    multiTermAnalyzerProperties = (SimpleOrderedMap)fieldTypeProperties.getVal(fieldTypePropNum);
                    continue;
                }
                if (fieldTypePropName.equals("similarity")) {
                    perFieldSimilarityProperties = (SimpleOrderedMap)fieldTypeProperties.getVal(fieldTypePropNum);
                    continue;
                }
                this.writeAttr(fieldTypePropName, fieldTypeProperties.getVal(fieldTypePropNum).toString());
            }
            boolean bl = isEmptyTag = null == analyzerProperties && null == indexAnalyzerProperties && null == queryAnalyzerProperties && null == multiTermAnalyzerProperties && null == perFieldSimilarityProperties;
            if (isEmptyTag) {
                this.closeStartTag(true);
                continue;
            }
            this.closeStartTag(false);
            this.incLevel();
            if (null != analyzerProperties) {
                this.writeAnalyzer((SimpleOrderedMap<Object>)analyzerProperties, null);
            }
            if (null != indexAnalyzerProperties) {
                this.writeAnalyzer((SimpleOrderedMap<Object>)indexAnalyzerProperties, "index");
            }
            if (null != queryAnalyzerProperties) {
                this.writeAnalyzer((SimpleOrderedMap<Object>)queryAnalyzerProperties, "query");
            }
            if (null != multiTermAnalyzerProperties) {
                this.writeAnalyzer((SimpleOrderedMap<Object>)multiTermAnalyzerProperties, "multiterm");
            }
            if (null != perFieldSimilarityProperties) {
                this.writeSimilarity((SimpleOrderedMap<Object>)perFieldSimilarityProperties);
            }
            this.decLevel();
            this.endTag("fieldType");
        }
        this.decLevel();
        this.endTag("types");
    }

    private void writeSimilarity(SimpleOrderedMap<Object> similarityProperties) throws IOException {
        this.openStartTag("similarity");
        this.writeAttr("class", similarityProperties.get("class").toString());
        if (similarityProperties.size() > 1) {
            this.closeStartTag(false);
            this.incLevel();
            this.writeNamedList(null, (NamedList)similarityProperties);
            this.decLevel();
            this.endTag("similarity");
        } else {
            this.closeStartTag(true);
        }
    }

    private void writeAnalyzer(SimpleOrderedMap<Object> analyzerProperties, String analyzerType) throws IOException {
        boolean isEmptyTag;
        this.openStartTag("analyzer");
        if (null != analyzerType) {
            this.writeAttr("type", analyzerType);
        }
        List charFilterPropertiesList = null;
        SimpleOrderedMap tokenizerProperties = null;
        List filterPropertiesList = null;
        for (int i = 0; i < analyzerProperties.size(); ++i) {
            String name = analyzerProperties.getName(i);
            if (name.equals("charFilters")) {
                charFilterPropertiesList = (List)analyzerProperties.getVal(i);
                continue;
            }
            if (name.equals("tokenizer")) {
                tokenizerProperties = (SimpleOrderedMap)analyzerProperties.getVal(i);
                continue;
            }
            if (name.equals("filters")) {
                filterPropertiesList = (List)analyzerProperties.getVal(i);
                continue;
            }
            if (!name.equals("class") || "solr.TokenizerChain".equals(analyzerProperties.getVal(i))) continue;
            this.writeAttr(name, analyzerProperties.getVal(i).toString());
        }
        boolean bl = isEmptyTag = null == charFilterPropertiesList && null == tokenizerProperties && null == filterPropertiesList;
        if (isEmptyTag) {
            this.closeStartTag(true);
        } else {
            int i;
            this.closeStartTag(false);
            this.incLevel();
            if (null != charFilterPropertiesList) {
                for (SimpleOrderedMap charFilterProperties : charFilterPropertiesList) {
                    this.openStartTag("charFilter");
                    for (i = 0; i < charFilterProperties.size(); ++i) {
                        this.writeAttr(charFilterProperties.getName(i), charFilterProperties.getVal(i).toString());
                    }
                    this.closeStartTag(true);
                }
            }
            if (null != tokenizerProperties) {
                this.openStartTag("tokenizer");
                for (int i2 = 0; i2 < tokenizerProperties.size(); ++i2) {
                    this.writeAttr(tokenizerProperties.getName(i2), tokenizerProperties.getVal(i2).toString());
                }
                this.closeStartTag(true);
            }
            if (null != filterPropertiesList) {
                for (SimpleOrderedMap filterProperties : filterPropertiesList) {
                    this.openStartTag("filter");
                    for (i = 0; i < filterProperties.size(); ++i) {
                        this.writeAttr(filterProperties.getName(i), filterProperties.getVal(i).toString());
                    }
                    this.closeStartTag(true);
                }
            }
            this.decLevel();
            this.endTag("analyzer");
        }
    }

    void openStartTag(String tag) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write('<');
        this.writer.write(tag);
    }

    void closeStartTag(boolean isEmptyTag) throws IOException {
        if (isEmptyTag) {
            this.writer.write('/');
        }
        this.writer.write('>');
    }

    void endTag(String tag) throws IOException {
        this.endTag(tag, true);
    }

    void endTag(String tag, boolean indentThisTag) throws IOException {
        if (this.doIndent && indentThisTag) {
            this.indent();
        }
        this.writer.write('<');
        this.writer.write('/');
        this.writer.write(tag);
        this.writer.write('>');
    }

    private void writeAttr(String name, String val) throws IOException {
        this.writeAttr(name, val, true);
    }

    public void writeAttr(String name, String val, boolean escape) throws IOException {
        if (val != null) {
            this.writer.write(' ');
            this.writer.write(name);
            this.writer.write("=\"");
            if (escape) {
                XML.escapeAttributeValue((String)val, (Writer)this.writer);
            } else {
                this.writer.write(val);
            }
            this.writer.write('\"');
        }
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
        int sz = val.size();
        for (int i = 0; i < sz; ++i) {
            String valName = val.getName(i);
            if (valName.equals("class")) continue;
            this.writeVal(valName, val.getVal(i));
        }
    }

    void startTag(String tag, String name, boolean closeTag) throws IOException {
        if (this.doIndent) {
            this.indent();
        }
        this.writer.write('<');
        this.writer.write(tag);
        if (name != null) {
            this.writeAttr("name", name);
            if (closeTag) {
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else if (closeTag) {
            this.writer.write("/>");
        } else {
            this.writer.write('>');
        }
    }

    @Override
    public void writeMap(String name, Map map, boolean excludeOuter, boolean isFirstVal) throws IOException {
        int sz = map.size();
        if (!excludeOuter) {
            this.startTag("lst", name, sz <= 0);
            this.incLevel();
        }
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.writeVal(null == k ? null : k.toString(), v);
        }
        if (!excludeOuter) {
            this.decLevel();
            if (sz > 0) {
                if (this.doIndent) {
                    this.indent();
                }
                this.writer.write("</lst>");
            }
        }
    }

    @Override
    public void writeArray(String name, Object[] val) throws IOException {
        this.writeArray(name, Arrays.asList(val).iterator());
    }

    @Override
    public void writeArray(String name, Iterator iter) throws IOException {
        if (iter.hasNext()) {
            this.startTag("arr", name, false);
            this.incLevel();
            while (iter.hasNext()) {
                this.writeVal(null, iter.next());
            }
            this.decLevel();
            if (this.doIndent) {
                this.indent();
            }
            this.writer.write("</arr>");
        } else {
            this.startTag("arr", name, true);
        }
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.writePrim("null", name, "", false);
    }

    @Override
    public void writeStr(String name, String val, boolean escape) throws IOException {
        this.writePrim("str", name, val, escape);
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.writePrim("int", name, val, false);
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.writePrim("long", name, val, false);
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.writePrim("bool", name, val, false);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.writePrim("float", name, val, false);
    }

    @Override
    public void writeFloat(String name, float val) throws IOException {
        this.writeFloat(name, Float.toString(val));
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.writePrim("double", name, val, false);
    }

    @Override
    public void writeDouble(String name, double val) throws IOException {
        this.writeDouble(name, Double.toString(val));
    }

    @Override
    public void writeDate(String name, String val) throws IOException {
        this.writePrim("date", name, val, false);
    }

    private void writePrim(String tag, String name, String val, boolean escape) throws IOException {
        int contentLen = val == null ? 0 : val.length();
        this.startTag(tag, name, contentLen == 0);
        if (contentLen == 0) {
            return;
        }
        if (escape) {
            XML.escapeCharData((String)val, (Writer)this.writer);
        } else {
            this.writer.write(val, 0, contentLen);
        }
        this.writer.write('<');
        this.writer.write('/');
        this.writer.write(tag);
        this.writer.write('>');
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
    }

    @Override
    public void writeEndDocumentList() throws IOException {
    }
}

