/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.HashMap;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CollectionsHandler.class);
    protected final CoreContainer coreContainer;
    public static long DEFAULT_ZK_TIMEOUT = 60000L;

    public CollectionsHandler() {
        this.coreContainer = null;
    }

    public CollectionsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        SolrParams params = req.getParams();
        CollectionParams.CollectionAction action = null;
        String a = params.get("action");
        if (a != null) {
            action = CollectionParams.CollectionAction.get((String)a);
        }
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
        }
        switch (action) {
            case CREATE: {
                this.handleCreateAction(req, rsp);
                break;
            }
            case DELETE: {
                this.handleDeleteAction(req, rsp);
                break;
            }
            case RELOAD: {
                this.handleReloadAction(req, rsp);
                break;
            }
            case SYNCSHARD: {
                this.handleSyncShardAction(req, rsp);
                break;
            }
            case CREATEALIAS: {
                this.handleCreateAliasAction(req, rsp);
                break;
            }
            case DELETEALIAS: {
                this.handleDeleteAliasAction(req, rsp);
                break;
            }
            case SPLITSHARD: {
                this.handleSplitShardAction(req, rsp);
                break;
            }
            case DELETESHARD: {
                this.handleDeleteShardAction(req, rsp);
                break;
            }
            default: {
                throw new RuntimeException("Unknown action: " + action);
            }
        }
        rsp.setHttpCaching(false);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        this.handleResponse(operation, m, rsp, DEFAULT_ZK_TIMEOUT);
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.currentTimeMillis();
        DistributedQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerCollectionQueue().offer(ZkStateReader.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.currentTimeMillis() - time >= timeout) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the collection unkown case");
        }
    }

    private void handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Reloading Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "reloadcollection", "name", name});
        this.handleResponse("reloadcollection", m, rsp);
    }

    private void handleSyncShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException, SolrServerException, IOException {
        log.info("Syncing shard : " + req.getParamString());
        String collection = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        Replica leaderProps = clusterState.getLeader(collection, shard);
        ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)leaderProps);
        HttpSolrServer server = new HttpSolrServer(nodeProps.getBaseUrl());
        server.setConnectionTimeout(15000);
        server.setSoTimeout(30000);
        CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
        reqSyncShard.setCollection(collection);
        reqSyncShard.setShard(shard);
        reqSyncShard.setCoreName(nodeProps.getCoreName());
        server.request((SolrRequest)reqSyncShard);
    }

    private void handleCreateAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        log.info("Create alias action : " + req.getParamString());
        String name = req.getParams().required().get("name");
        String collections = req.getParams().required().get("collections");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "createalias", "name", name, "collections", collections});
        this.handleResponse("createalias", m, rsp);
    }

    private void handleDeleteAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        log.info("Delete alias action : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletealias", "name", name});
        this.handleResponse("createalias", m, rsp);
    }

    private void handleDeleteAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Deleting Collection : " + req.getParamString());
        String name = req.getParams().required().get("name");
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletecollection", "name", name});
        this.handleResponse("deletecollection", m, rsp);
    }

    private void handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException {
        log.info("Creating Collection : " + req.getParamString());
        Integer numReplicas = req.getParams().getInt("replicationFactor", 1);
        String name = req.getParams().required().get("name");
        String configName = req.getParams().get("collection.configName");
        String numShards = req.getParams().get("numShards");
        String maxShardsPerNode = req.getParams().get("maxShardsPerNode");
        String createNodeSetStr = req.getParams().get("createNodeSet");
        if (name == null) {
            log.error("Collection name is required to create a new collection");
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection name is required to create a new collection");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "createcollection");
        props.put("replicationFactor", numReplicas.toString());
        props.put("name", name);
        if (configName != null) {
            props.put("collection.configName", configName);
        }
        props.put("numShards", numShards);
        props.put("maxShardsPerNode", maxShardsPerNode);
        props.put("createNodeSet", createNodeSetStr);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("createcollection", m, rsp);
    }

    private void handleDeleteShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws InterruptedException, KeeperException {
        log.info("Deleting Shard : " + req.getParamString());
        String name = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("collection", name);
        props.put("operation", "deleteshard");
        props.put("shard", shard);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("deleteshard", m, rsp);
    }

    private void handleSplitShardAction(SolrQueryRequest req, SolrQueryResponse rsp) throws KeeperException, InterruptedException {
        log.info("Splitting shard : " + req.getParamString());
        String name = req.getParams().required().get("collection");
        String shard = req.getParams().required().get("shard");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "splitshard");
        props.put("collection", name);
        props.put("shard", shard);
        ZkNodeProps m = new ZkNodeProps(props);
        this.handleResponse("splitshard", m, rsp, DEFAULT_ZK_TIMEOUT * 5L);
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud Collections";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/trunk/solr/core/src/java/org/apache/solr/handler/admin/CollectionHandler.java $";
    }
}

