/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardLeaderElectionContextBase
extends ElectionContext {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContextBase.class);
    protected final SolrZkClient zkClient;
    protected String shardId;
    protected String collection;
    protected LeaderElector leaderElector;

    public ShardLeaderElectionContextBase(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkStateReader zkStateReader) {
        super(coreNodeName, "/collections/" + collection + "/leader_elect/" + shardId, ZkStateReader.getShardLeadersPath((String)collection, (String)shardId), props, zkStateReader.getZkClient());
        this.leaderElector = leaderElector;
        this.zkClient = zkStateReader.getZkClient();
        this.shardId = shardId;
        this.collection = collection;
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        this.zkClient.makePath(this.leaderPath, ZkStateReader.toJSON((Object)this.leaderProps), CreateMode.EPHEMERAL, true);
        assert (this.shardId != null);
        ZkNodeProps m = ZkNodeProps.fromKeyVals((Object[])new Object[]{"operation", "leader", "shard", this.shardId, "collection", this.collection, "base_url", this.leaderProps.getProperties().get("base_url"), "core", this.leaderProps.getProperties().get("core"), "state", "active"});
        Overseer.getInQueue(this.zkClient).offer(ZkStateReader.toJSON((Object)m));
    }
}

