/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;

public class Assign {
    private static Pattern COUNT = Pattern.compile("core_node(\\d+)");

    public static String assignNode(String collection, ClusterState state) {
        Map sliceMap = state.getSlicesMap(collection);
        if (sliceMap == null) {
            return "core_node1";
        }
        int max = 0;
        for (Slice slice : sliceMap.values()) {
            for (Replica replica : slice.getReplicas()) {
                Matcher m = COUNT.matcher(replica.getName());
                if (!m.matches()) continue;
                max = Math.max(max, Integer.parseInt(m.group(1)));
            }
        }
        return "core_node" + (max + 1);
    }

    public static String assignShard(String collection, ClusterState state, Integer numShards) {
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map sliceMap = state.getActiveSlicesMap(collection);
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer one = (Integer)map.get(o1);
                Integer two = (Integer)map.get(o2);
                return one.compareTo(two);
            }
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }
}

