/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.cms.CompressedDataParser;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSCompressedDataParser(InputStream inputStream) throws CMSException {
        super(inputStream);
    }

    public CMSTypedStream getContent() throws CMSException {
        try {
            CompressedDataParser compressedDataParser = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser contentInfoParser = compressedDataParser.getEncapContentInfo();
            ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser.getContent(4);
            return new CMSTypedStream(contentInfoParser.getContentType().toString(), new InflaterInputStream(aSN1OctetStringParser.getOctetStream()));
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading compressed content.", iOException);
        }
    }
}

